<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" >
	<!-- 2015/08/08 K.H ID属性(#CustomData) を、class属性(.MonitorTbl) に変更 -->
	<style type="text/css">
		/* モニターテーブルの幅 */
/*		.MonitorTbl td { width : 20px; }	*/

		/* モニターを移動させるための設定 */
		.boxID { position: absolute; }

		/* モニターが移動できる範囲の設定。背景に、LOC_GRP 単位に切り替えるサンプル。 */
		.factoryLayout {
			height : 100%;
			width  : 100%;
			background-size  : 800px;
<og:text>	background-image : url( {@LOC_GRP}_japan.png );	</og:text>
			background-repeat: no-repeat;
		}
	</style>

	<!-- モニターを移動させる JavaScript本体。jQueryのdraggableで、位置情報をentry.jsp に投げてMEMOに書き込んでいるだけ -->
	<script type="text/javascript">
		$(function(){
			$(".boxID").draggable( {
				containment: 'parent',			// 親範囲の中のみで移動
				opacity: 0.5,					// 移動中のオブジェクトの透明度
				grid: [10, 10],					// 移動時のグリッド
				stop: function ( ev, ui ) {		// 移動終了時の callメソッド
			//		alert( $(this).attr("id") + "," + Math.round($(this).offset().left) + "," + Math.round($(this).offset().top) );
					$.ajax({
							url		: 'entry.jsp',
							data	: { UNIQ:   $(this).attr("id") ,
										LOC_COL: Math.round($(this).offset().left) ,
										LOC_ROW: Math.round($(this).offset().top) ,
									  } ,
							async	: true,
							type	: 'GET',
							dataType: 'html' ,
					});
				 }
			 } );
		});
	</script>

</og:head>

<jsp:directive.include file="/jsp/custom/none_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7221"
	title	= "配置図/座席表配置"
	date	= "2015/09/14"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
 -->
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:switch key="{@LOC_GRP}">
	<og:case match="BLOCK">
		<og:value key="HIRITU" value="200000" />
		<og:value key="WIDTH"  value="10px" />
	</og:case>
	<og:case match="BRANCH">
		<og:value key="HIRITU" value="100000" />
		<og:value key="WIDTH"  value="5px" />
	</og:case>
	<og:case isDefault="true">
		<og:value key="HIRITU" value="100000" />
		<og:value key="WIDTH"  value="5px" />
	</og:case>
</og:switch>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.{@LOC_GRP} as LOC_GRP,
			SUM(A.SALES)/{@HIRITU}               AS SALES1, SUM(A.SALES)          AS SALES,
			SUM(A.AMOUNT)/{@HIRITU}              AS AMOUNT1,SUM(A.AMOUNT)         AS AMOUNT,
			ABS(SUM(A.SALES-A.AMOUNT))/{@HIRITU} AS PROFIT1,SUM(A.SALES-A.AMOUNT) AS PROFIT,
			rtrim(CASE WHEN SUM(A.SALES-A.AMOUNT) &lt; 0 THEN '0' ELSE '1' END) AS SIGN,
			B.LABEL_NAME , B.UNIQ , B.LOC_COL , B.LOC_ROW
		from GF43 A inner join GF46 B
					on  A.{@LOC_GRP}  = B.R_KEY1
	<og:where>
		<og:and value = "B.LOC_GRP	= '{@LOC_GRP}'"	/>
		<og:and value = "A.YEAR		= '{@YEAR}'"	/>
		<og:and value = "A.BLOCK	= '{@BLOCK}'"	/>
	</og:where>
		GROUP BY A.{@LOC_GRP},B.LABEL_NAME , B.UNIQ ,B.LOC_COL , B.LOC_ROW
		ORDER BY SALES1 DESC
</og:query>

<og:text>{@SYS.DATE}</og:text><br />

<br/>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<div class="factoryLayout">
	<og:view
		viewFormType = "CustomData"
		command		 = "{@command}"
		writable	 = "false"
		useScrollBar = "false"
		numberType	 = "delete"
		bgColorCycle = "1"
		useHilightRow= "false"
	>
		<og:thead rowspan="1"><!-- --></og:thead>
		<og:tbody usableKey="SIGN" usableList="1" rowspan="1">
		  <!-- モニターを移動させるための設定。style属性に、位置を指定。 -->
		  <div class="boxID" id="[UNIQ]" style="left:[LOC_COL]px; top:[LOC_ROW]px;">
			<table class="MonitorTbl">
				<tr>
					<td style="vertical-align:bottom"><img height="[SALES1]px"  width="{@WIDTH}" src="{@SYS.JSP}/image/space_green.gif" alt="[SALES1]"  /></td>
					<td style="vertical-align:bottom"><img height="[AMOUNT1]px" width="{@WIDTH}" src="{@SYS.JSP}/image/space_blue.gif"  alt="[AMOUNT1]" /></td>
					<td style="vertical-align:bottom"><img height="[PROFIT1]px" width="{@WIDTH}" src="{@SYS.JSP}/image/space_brown.gif" alt="[PROFIT1]" /></td>
				</tr>
				<tr>
					<td colspan="3" style="font-size:50%;">[LOC_GRP]</td>
				</tr>
			</table>
		  </div>
		</og:tbody>
		<og:tbody usableKey="SIGN" usableList="0" rowspan="1" >
		  <!-- モニターを移動させるための設定。style属性に、位置を指定。 -->
		  <div class="boxID" id="[UNIQ]" style="left:[LOC_COL]px; top:[LOC_ROW]px;">
			<table class="MonitorTbl">
				<tr>
					<td style="vertical-align:bottom"><img height="[SALES1]px"  width="{@WIDTH}" src="{@SYS.JSP}/image/space_green.gif" alt="[SALES1]"  /></td>
					<td style="vertical-align:bottom"><img height="[AMOUNT1]px" width="{@WIDTH}" src="{@SYS.JSP}/image/space_blue.gif"  alt="[AMOUNT1]" /></td>
					<td style="vertical-align:bottom"><img height="[PROFIT1]px" width="{@WIDTH}" src="{@SYS.JSP}/image/space_red.gif"   alt="[PROFIT1]" /></td><td></td>
				</tr>
				<tr>
					<td colspan="3" style="font-size:50%;">[LOC_GRP]</td>
				</tr>
			</table>
		  </div>
		</og:tbody>
	</og:view>

	<div id="imgTag" class="boxID" style="left:640px; top:500px;" ><!-- -->
		<div id="imgBody"><!-- --></div>
	</div>
</div>

<og:hidden  name="REFRESH" value="{@NVL.REFRESH 60}" />
<script for="window" event="onload">
		setTimeout(
			function() {
				location.reload();
			}, (document.getElementById("REFRESH").value * 1000)
		);
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
