/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* DYNAMIC_PKG ( PACKAGE BODY )                                             */
/* Created : 2015/09/26 15:51:09                                            */
/****************************************************************************/
CREATE 
PACKAGE BODY DYNAMIC_PKG AS
/*****************************************************************************/
/*	品番マスタ検索処理													 	 */
/*****************************************************************************/
	PROCEDURE DYNAMIC_TEST(
		P_KEKKA		OUT	NUMBER,
		P_ERRMSGS	OUT	ERR_MSG_ARRAY,
		P_KEYS		IN	ARG_ARRAY,
		P_ARGS		IN	ARG_ARRAY ) IS
-------------------------------------------------------------------------------
---------------------------<< 変数宣言 >> -------------------------------------
-------------------------------------------------------------------------------
	-- エラーラベル
	SUBSCRIPT_NOT_EXISTS	EXCEPTION;	-- 配列要素エラー
	TOO_MANY_ERRORS			EXCEPTION;	-- エラー件数最大数オーバーエラー
	ACQUIRE_WITH_NOWAIT		EXCEPTION;	-- NOWAIT時ロックエラー

	BEGIN
		FOR I IN 1..P_KEYS.COUNT LOOP
			HYBS.SET_ERRMSGS(P_ERRMSGS,				-- エラーメッセージ配列
						I,							-- 行番号
						2,							-- エラー結果(0:正常 1:警告 2:異常)
						'ERR0013',					-- エラーメッセージＩＤ
						P_KEYS(I),					-- メッセージパラメータ１
						P_ARGS(I) );				-- メッセージパラメータ２
		END LOOP;

		P_KEKKA := 2;

	EXCEPTION
		WHEN HYBS.TOO_MANY_ERRORS THEN
			HYBS.SET_LIMITOVER(P_ERRMSGS);
			P_KEKKA := 2;
		WHEN OTHERS THEN
--			オラクルエラー。
			HYBS.SET_ERRMSGS(P_ERRMSGS,				-- エラーメッセージ配列
						2,							-- 行番号
						2,							-- エラー結果(0:正常 1:警告 2:異常)
						to_char(SQLCODE),			-- オラクルエラーコード
						substrb( SQLERRM,1,100 ));	-- オラクルエラーメッセージ
			P_KEKKA := 2;
	END DYNAMIC_TEST;

END DYNAMIC_PKG;
;
