/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.opengion.fukurou.util.AbstractConnect;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.StringUtil;

public final class SFTPConnect
extends AbstractConnect {
    private final JSch jsch = new JSch();
    private static final int DEF_PORT = 22;
    private boolean isConnect;
    private String lastRemoteDir = "/";
    private String keyFile;
    private Session session;
    private ChannelSftp channel;

    @Override
    public void connect() {
        if (this.isDisplay) {
            System.out.println("CONNECT: HOST=" + this.host + ",USER=" + this.user + ",PORT=" + this.port);
        }
        if (this.isConnect) {
            this.disconnect();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("StrictHostKeyChecking", "no");
        JSch.setConfig(hashtable);
        try {
            if (this.keyFile == null) {
                this.session = this.jsch.getSession(this.user, this.host, this.getPort(22));
                this.session.setPassword(this.passwd);
            } else {
                this.jsch.addIdentity(this.keyFile);
                this.session = this.jsch.getSession(this.user, this.host, this.getPort(22));
            }
            this.session.connect(this.timeout * 1000);
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
        }
        catch (JSchException jSchException) {
            this.errAppend((Object)"SFTP server refused connection. ");
            this.errAppend("   host    = [", this.host, "]");
            this.errAppend("   user    = [", this.user, "]");
            this.errAppend("   port    = [", this.port, "]");
            this.errAppend((Object)jSchException);
            if (this.isDebug) {
                jSchException.printStackTrace();
            }
            this.disconnect();
            throw new RuntimeException(this.getErrMsg(), jSchException);
        }
        this.isConnect = true;
    }

    @Override
    public void disconnect() {
        if (this.isDisplay) {
            System.out.println("DISCONNECT:");
        }
        if (this.isConnect) {
            this.isConnect = false;
            try {
                this.channel.disconnect();
                this.session.disconnect();
            }
            catch (Throwable throwable) {
                this.errAppend((Object)"disconnect Error.");
                this.errAppend((Object)throwable);
                if (this.isDebug) {
                    throwable.printStackTrace();
                }
                throw new RuntimeException(this.getErrMsg(), throwable);
            }
        }
    }

    @Override
    protected void actionGET(String string, String string2) throws IOException {
        if (this.isDebug) {
            System.out.println("GET: " + string2 + " => " + string);
        }
        if (this.isMkdirs) {
            this.makeLocalDir(string);
        }
        try {
            this.channel.get(string2, string);
        }
        catch (SftpException sftpException) {
            String string3 = "\u30c1\u30e3\u30cd\u30eb(get)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002localFile=[" + string + "], remoteFile=[" + string2 + "]";
            throw new IOException(string3, sftpException);
        }
    }

    @Override
    protected void actionGETdir(String string, String string2) throws IOException {
        Vector vector;
        try {
            vector = this.channel.ls(string2);
        }
        catch (SftpException sftpException) {
            String string3 = "\u30c1\u30e3\u30cd\u30eb(ls)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002remoteDir=[" + string2 + "]";
            throw new IOException(string3, sftpException);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)vector.get(i);
            String string4 = lsEntry.getFilename();
            if (".".equals(string4) || "..".equals(string4)) continue;
            SftpATTRS sftpATTRS = lsEntry.getAttrs();
            if (sftpATTRS.isDir()) {
                this.actionGETdir(this.addFile(string, string4), this.addFile(string2, string4));
                continue;
            }
            this.actionGET(this.addFile(string, string4), this.addFile(string2, string4));
        }
    }

    @Override
    protected void actionPUT(String string, String string2) throws IOException {
        if (this.isDebug) {
            System.out.println("PUT: " + string + " => " + string2);
        }
        try {
            if (this.isMkdirs) {
                int n = string2.lastIndexOf(47) + 1;
                String string3 = string2.substring(0, n);
                if (n > 0 && !this.lastRemoteDir.startsWith(string3)) {
                    this.lastRemoteDir = string3;
                    if (StringUtil.startsChar(string2, '/')) {
                        String[] stringArray = string2.split("/");
                        this.channel.cd("/");
                        for (int i = 1; i < stringArray.length - 1; ++i) {
                            try {
                                this.channel.cd(stringArray[i]);
                                continue;
                            }
                            catch (SftpException sftpException) {
                                this.channel.mkdir(stringArray[i]);
                                this.channel.cd(stringArray[i]);
                            }
                        }
                    }
                }
            }
            this.channel.put(string, string2);
        }
        catch (SftpException sftpException) {
            String string4 = "\u30c1\u30e3\u30cd\u30eb(put)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002localFile=[" + string + "], remoteFile=[" + string2 + "]";
            throw new IOException(string4, sftpException);
        }
    }

    @Override
    protected void actionDEL(String string) throws IOException {
        if (this.isDebug) {
            System.out.println("DEL: " + string);
        }
        try {
            this.channel.rm(string);
        }
        catch (SftpException sftpException) {
            String string2 = "\u30c1\u30e3\u30cd\u30eb(rm)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002remoteFile=[" + string + "]";
            throw new IOException(string2, sftpException);
        }
    }

    @Override
    protected void actionDELdir(String string) throws IOException {
        Object object;
        Vector vector;
        try {
            vector = this.channel.ls(string);
        }
        catch (SftpException sftpException) {
            String string2 = "\u30c1\u30e3\u30cd\u30eb(ls)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002remoteDir=[" + string + "]";
            throw new IOException(string2, sftpException);
        }
        for (int i = 0; i < vector.size(); ++i) {
            object = (ChannelSftp.LsEntry)vector.get(i);
            String string3 = object.getFilename();
            if (".".equals(string3) || "..".equals(string3)) continue;
            SftpATTRS sftpATTRS = object.getAttrs();
            if (sftpATTRS.isDir()) {
                this.actionDELdir(this.addFile(string, string3));
                continue;
            }
            this.actionDEL(this.addFile(string, string3));
        }
        try {
            this.channel.rmdir(string);
        }
        catch (SftpException sftpException) {
            object = "\u30c1\u30e3\u30cd\u30eb(rmdir)\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002remoteDir=[" + string + "]";
            throw new IOException((String)object, sftpException);
        }
    }

    public void setKeyFile(String string) {
        if (string != null) {
            this.keyFile = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"GET", "PUT", "DEL", "GETDIR", "PUTDIR", "DELDIR"};
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("host", "\u63a5\u7d9a\u5148\u306eSFTP\u30b5\u30fc\u30d0\u30fc\u306e\u30a2\u30c9\u30ec\u30b9\u307e\u305f\u306f\u3001\u30b5\u30fc\u30d0\u30fc\u540d(\u5fc5\u9808)");
        linkedHashMap.put("user", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u540d(\u5fc5\u9808)");
        linkedHashMap.put("remoteFile", "\u63a5\u7d9a\u5148\u306eSFTP\u30b5\u30fc\u30d0\u30fc\u5074\u306e\u30d5\u30a1\u30a4\u30eb\u540d(\u5fc5\u9808)");
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.put("passwd", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u306e\u30d1\u30b9\u30ef\u30fc\u30c9");
        linkedHashMap2.put("localFile", "\u30ed\u30fc\u30ab\u30eb\u306e\u30d5\u30a1\u30a4\u30eb\u540d");
        linkedHashMap2.put("port", "\u63a5\u7d9a\u306b\u5229\u7528\u3059\u308b\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        linkedHashMap2.put("keyFile", "\u516c\u958b\u30ad\u30fc\u6697\u53f7\u5316\u65b9\u5f0f\u3092\u5229\u7528\u3059\u308b\u5834\u5408\u306e\u30ad\u30fc\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        linkedHashMap2.put("command", "SFTP\u30b5\u30fc\u30d0\u30fc\u5074\u3067\u306e\u51e6\u7406\u306e\u65b9\u6cd5(GET/PUT/DEL)\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:GET)");
        linkedHashMap2.put("mkdirs", "\u53d7\u3051\u5074\u30d5\u30a1\u30a4\u30eb(GET\u6642:LOCAL\u3001PUT\u6642:SFTP\u30b5\u30fc\u30d0\u30fc)\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3059\u308b\u304b\u3069\u3046\u304b(\u521d\u671f\u5024:true)");
        linkedHashMap2.put("timeout", "Data\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8(\u521d\u671f\u5024:600 [\u79d2])");
        linkedHashMap2.put("display", "[false/true]:true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        linkedHashMap2.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        Argument argument = new Argument("org.opengion.fukurou.util.SFTPConnect");
        argument.setMustProparty(linkedHashMap);
        argument.setUsableProparty(linkedHashMap2);
        argument.setArgument(stringArray);
        SFTPConnect sFTPConnect = new SFTPConnect();
        String string = argument.getProparty("host");
        String string2 = argument.getProparty("user");
        String string3 = argument.getProparty("passwd");
        sFTPConnect.setHostUserPass(string, string2, string3);
        sFTPConnect.setPort(argument.getProparty("port"));
        sFTPConnect.setKeyFile(argument.getProparty("keyFile"));
        sFTPConnect.setMkdirs(argument.getProparty("mkdirs", true));
        sFTPConnect.setTimeout(argument.getProparty("timeout", 600));
        sFTPConnect.setDisplay(argument.getProparty("display", false));
        sFTPConnect.setDebug(argument.getProparty("debug", false));
        try {
            sFTPConnect.connect();
            String string4 = argument.getProparty("command", "GET", stringArray2);
            String string5 = argument.getProparty("localFile");
            String string6 = argument.getProparty("remoteFile");
            sFTPConnect.action(string4, string5, string6);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(sFTPConnect.getErrMsg());
        }
        finally {
            sFTPConnect.disconnect();
        }
    }
}

