/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.opengion.fukurou.util.DateSet;
import org.opengion.fukurou.util.HybsDateUtil;

public final class LogWriter {
    private static PrintWriter writer;
    private static final Object LOCK;
    private static String logFileUrl;

    private LogWriter() {
    }

    public static void init(String string) {
        logFileUrl = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String string) {
        Object object = LOCK;
        synchronized (object) {
            if (writer == null) {
                writer = LogWriter.getPrintWriter();
            }
        }
        writer.println("[WriteTime= " + HybsDateUtil.getDate("yyyy/MM/dd HH:mm:ss.SSS") + "] " + string);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Throwable throwable) {
        Object object = LOCK;
        synchronized (object) {
            if (writer == null) {
                writer = LogWriter.getPrintWriter();
            }
        }
        throwable.printStackTrace(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = LOCK;
        synchronized (object) {
            if (writer != null) {
                writer.close();
            }
            writer = null;
        }
    }

    private static PrintWriter getPrintWriter() {
        if (logFileUrl == null || logFileUrl.isEmpty()) {
            return new PrintWriter(System.err);
        }
        DateSet dateSet = new DateSet();
        String string = dateSet.changeString(logFileUrl);
        try {
            File file = new File(string);
            return new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        }
        catch (IOException iOException) {
            String string2 = "\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
            throw new RuntimeException(string2, iOException);
        }
    }

    static {
        LOCK = new Object();
    }
}

