/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;

public final class DocletVerCheck {
    private static final String SELECT_PACKAGE = "org.opengion";
    private static final String ENCODE = "UTF-8";
    private static final String OG_REV = "og.rev";
    private static final Map<String, Set<String[]>> verInfo = new TreeMap<String, Set<String[]>>();
    private static int debugLevel;

    private DocletVerCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        String string3 = DocletUtil.getOption("-debugLevel", rootDoc.options());
        if (string3 != null) {
            debugLevel = Integer.parseInt(string3);
        }
        try (DocletTagWriter docletTagWriter = null;){
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            DocletVerCheck.writeContents(rootDoc.classes(), docletTagWriter, string);
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter, String string) {
        String string2;
        Object object;
        ExecutableMemberDoc[][] executableMemberDocArrayArray = new ExecutableMemberDoc[2][];
        for (int i = 0; i < classDocArray.length; ++i) {
            object = classDocArray[i];
            Object object2 = object.qualifiedName();
            object2 = ((String)object2).substring(SELECT_PACKAGE.length() + 1);
            executableMemberDocArrayArray[0] = object.constructors(false);
            executableMemberDocArrayArray[1] = object.methods(false);
            for (int j = 0; j < executableMemberDocArrayArray.length; ++j) {
                block2: for (int k = 0; k < executableMemberDocArrayArray[j].length; ++k) {
                    string2 = executableMemberDocArrayArray[j][k];
                    Tag[] tagArray = string2.tags(OG_REV);
                    for (int i2 = 0; i2 < tagArray.length; ++i2) {
                        String[] stringArray = tagArray[i2].text();
                        if (!stringArray.startsWith(string)) continue;
                        Set<String[]> set = verInfo.get(stringArray);
                        if (set == null) {
                            set = new TreeSet<String[]>(new ObjComp());
                        }
                        set.add(DocletVerCheck.menberCheck((ExecutableMemberDoc)string2, (String)object2));
                        verInfo.put((String)stringArray, set);
                        continue block2;
                    }
                }
            }
        }
        String string3 = null;
        object = "";
        for (Map.Entry entry : verInfo.entrySet()) {
            int n;
            String string4 = (String)entry.getKey();
            if (string3 == null) {
                int n2 = string4.indexOf(41);
                string3 = string4.substring(0, n2 + 1);
                docletTagWriter.printTag(string3);
            }
            if ((n = (string2 = string4.substring(string3.length()).trim()).indexOf(12290)) >= 0) {
                String string5 = string2.substring(0, n).trim();
                if (!((String)object).equals(string5)) {
                    docletTagWriter.printTag("\n\t[", string5, "]");
                    object = string5;
                }
                if (n != string2.length() - 1) {
                    docletTagWriter.printTag("\t", string2.substring(n + 1).trim());
                }
            } else {
                docletTagWriter.printTag("\n\t[", string2, "]");
                object = string2;
            }
            for (String[] stringArray : (Set)entry.getValue()) {
                if (debugLevel > 0) {
                    docletTagWriter.printTag(stringArray[2]);
                }
                docletTagWriter.printTag("\t\t", stringArray[0], "#", stringArray[1]);
            }
        }
    }

    private static String[] menberCheck(ExecutableMemberDoc executableMemberDoc, String string) {
        Object object;
        String string2 = executableMemberDoc.name();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(string2).append('(');
        Parameter[] parameterArray = executableMemberDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            object = parameterArray[i].type();
            String string3 = parameterArray[i].name();
            stringBuilder.append(object.typeName()).append(object.dimension()).append(' ').append(string3).append(',');
        }
        if (parameterArray.length > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(')');
        String string4 = stringBuilder.toString();
        object = executableMemberDoc.position().toString();
        System.out.println((String)object);
        return new String[]{string, string4, object};
    }

    public static int optionLength(String string) {
        if ("-version".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("-outfile".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("-debugLevel".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    private static final class ObjComp
    implements Comparator<String[]>,
    Serializable {
        private static final long serialVersionUID = 639020151030L;

        private ObjComp() {
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return stringArray[2].compareTo(stringArray2[2]);
        }
    }
}

