/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;
// import org.opengion.hayabusa.db.Selection_HM;		// 5.7.3.0 (2014/02/07) SelectionFactory を使う様に変更
import org.opengion.hayabusa.db.SelectionFactory;		// 5.7.3.0 (2014/02/07)

/**
 * カラムの編集パラメーターの開始、終了、ステップの情報より、プルダウンメニューを作成して
 * 編集する場合に使用するエディタークラスです。
 *
 * ここでは、時間(時:分）の自動生成を行います。パラメータで、開始、終了、ステップ、開始前設定値、終了後設定値
 * を指定できます。
 * キーは、４文字の HHMM 形式で与えられます。ラベルは、HH:MM になります。
 * ステップは、分単位です。
 * 開始前設定値、終了後設定値はそれぞれ、開始の前と終了の後ろに特別に値を設定できます。
 * パラメータの初期値は、開始(0700)、終了(1900)、ステップ(30)、開始前設定値(null)、終了後設定値(null) です。
 * 
 * 例：0800,2000,30  → 0800,0830,0900,0930,1000,・・・1900,1930,2000 のプルダウン
 * 例：0800,2000,30,0000:△,2400:▽  → 0000,0800,0830,0900,0930,1000,・・・1900,1930,2000,2400 のプルダウン
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 5.6.1.1 (2013/02/08) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_HMMENU extends Editor_MENU {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.7.3.0 (2014/02/07)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_HMMENU() {
		super();
	}

	/**
	 * コンストラクター。
	 *
	 * ここでは、親クラスの Editor_MENU で初期化を行い、セレクションオブジェクト に、
	 * Selection_HM を使用するように再設定します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) SelectionFactory 対応
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_HMMENU( final DBColumn clm ) {
		super( clm );

		// 5.7.3.0 (2014/02/07) SelectionFactory 対応
		// selection = new Selection_HM( clm.getEditorParam() );
		selection = SelectionFactory.newSelection( "HM", clm.getEditorParam() );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_HMMENU( clm );
	}
}
