/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.io;

import org.jfree.chart.imagemap.URLTagFragmentGenerator;

/**
 * Generates URLs using the HTML href attribute for image map area tags.
 */
public class HybsURLTagFragmentGenerator implements URLTagFragmentGenerator {
	private final String href ;

	/**
	 * デフォルトコンストラクター
	 *
	 */
	public HybsURLTagFragmentGenerator() {
		href = " href=\"";
	}

	/**
	 * 引数指定のコンストラクター
	 *
	 * 引数のターゲットに応じて、href に target 属性を追加しておきます。
	 * ターゲットが、null の場合は、デフォルトコンストラクターと同じ結果になります。
	 *
	 * @param	target ターゲット
	 */
	public HybsURLTagFragmentGenerator( final String target ) {
		if( target == null ) {
			href = " href=\"";
		}
		else {
			href = " target=\"" + target + "\" href=\"" ;
		}
	}

	/**
	 * 引数の URLテキストを使用して、href アドレス部を作成します。
	 *
	 * @param	urlText	URLテキスト
	 *
	 * @return	hrefアドレス
	 */
	public String generateURLFragment( final String urlText ) {
		return href + urlText + "\"";
	}

}
