/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.io.UnsupportedEncodingException;
import org.opengion.fukurou.util.StringUtil;

final class GUIAccessCount {
    private final String guiKey;
    private int accessCount = 0;
    private int errorCount = 0;
    private long readCount = 0L;
    private long writeCount = 0L;
    private long dbTime = 0L;
    private long maxDbTime = 0L;
    private String maxQuery = null;

    public GUIAccessCount(String string) {
        this.guiKey = string;
    }

    public String getKey() {
        return this.guiKey;
    }

    public void addReadCount(int n, long l, String string) {
        this.readCount += (long)n;
        this.dbTime += l;
        if (this.maxDbTime < l) {
            this.maxDbTime = l;
            this.maxQuery = string;
        }
    }

    public long getReadCount() {
        return this.readCount;
    }

    public void addWriteCount(int n, long l, String string) {
        this.writeCount += (long)n;
        this.dbTime += l;
        if (this.maxDbTime < l) {
            this.maxDbTime = l;
            this.maxQuery = string;
        }
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void addAccessCount() {
        ++this.accessCount;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public void addErrorCount() {
        ++this.errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getQueryTime() {
        return this.dbTime;
    }

    public long getMaxQueryTime() {
        return this.maxDbTime;
    }

    public String getMaxQuery() {
        String string;
        if (this.maxQuery == null) {
            string = "";
        } else if (this.maxQuery.length() < 1300) {
            string = this.maxQuery;
        } else {
            String string2;
            try {
                byte[] byArray = StringUtil.makeByte((String)this.maxQuery, (String)"UTF-8");
                string2 = new String(byArray, "UTF-8");
                if (string2.length() > 1300) {
                    string2 = string2.substring(0, 1300);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = this.maxQuery.substring(0, 1300);
            }
            string = string2;
        }
        return string;
    }
}

