/************************************************************************************/
/* 入力値自動変換機能 (query画面用)                                                 */
/* dbType に従って、カンマやスラッシュの削除を行います                              */
/* 完全にエンジンのチェックと一致しているわけではありません。                       */
/*                                                                                  */
/* S9,R：カンマ削除                                                                 */
/* PN  ：ハイフン削除                                                               */
/* YM,DATE系：スラッシュ削除                                                        */
/* HSM ：コロン削除                                                                 */
/*                                                                                  */
/* @og.rev 5.6.0.3 (2013/01/24) 新規追加                                            */
/* @og.rev 5.6.2.3 (2013/03/22) queryScriptPre.jsp → queryConvert.js 変更          */
/* @og.rev 6.3.2.0 (2015/07/10) PN から、スペースは削除するように変更               */
/* Revision: $Id$                                                                   */
/************************************************************************************/
$(function(){
	setEvent( "textarea,input[type=\"text\"]", "focusout", function(){ queryConvert( this ); } );
});

function queryConvert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( (cls.match( /S9/ ) || cls.match( /R/ ) || cls.match( /XU9/ )) && !cls.match( /\S+R\S*/ ) && !cls.match( /\S*R\S+/ ) ) {
//			obj.value = val.replace(',','');
			obj.value = val.replace(/,/g,'');
		}
		else if( cls.match( /PN/ ) ) {
//			obj.value = val.replace('-','');
//			obj.value = val.replace(/-/g,'');		// 6.3.2.0 (2015/07/10)
			obj.value = val.replace(/[ -]/g,'');
		}
		else if( cls.match( /YM/ ) || cls.match( /DATE/ ) ) {
//			obj.value = val.replace('/','');
			obj.value = val.replace(/\//g,'');
			if( cls.match( /YMDH/ ) ) {
				obj.value = val.replace(/[\/: ]/g,'');
			}
		}
		else if( cls.match( /HMS/ ) ) {
//			obj.value = val.replace(':','');
			obj.value = val.replace(/:/g,'');
		}
	}
	return true;
}