/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_SEQUENCE_HSQLDB は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、シーケンス一覧の検索結果より、GF09 のシーケンス定義テーブルから
 * 必要な情報を取得し、シーケンス作成スクリプトを作成します。
 *
 * この処理を実行するには、DBTableModelのカラムとして、
 *  SEQNAME,INCREBY,STARTVAL,MINVAL,MAXVAL,FGCYCLE,SUCACHE
 * が必要です。
 *
 * ※HSQLDBに対して生成されるスクリプトでは、MINVAL,MAXVAL,FGCYCLE,SUCACHEは無視されます。
 *
 * @og.rev 5.1.9.0 (2010/08/01) DB定義DB・シーケンス定義追加
 * @version  0.9.0  2010/08/01
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_SEQUENCE_HSQLDB extends TableFilter_SEQUENCE {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.0.2.3 (2014/10/10)" ;

	/**
	 * シーケンス作成の処理を実行します。
	 *
	 * @og.rev 6.0.2.3 (2014/10/10) isXml で、CR + EXEC_END_TAG のキャッシュ(execEndTag)を利用します。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	シーケンス作成
	 * @og.rtnNotNull
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data ) {
		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );

		if( isXml ) { buf.append( EXEC_START_TAG ).append( CR ); }

		buf.append( "CREATE SEQUENCE " ).append( data[clmNo[SEQNAME]] ).append( CR )
			.append( " AS INTEGER START WITH " ).append( data[clmNo[STARTVAL]] )
			.append( " INCREMENT BY " ).append( data[clmNo[INCREBY]] )
			// 6.0.2.3 (2014/10/10) EXEC_END_TAG の置き換え＋"/" の判定が必要。
			.append( execEndTag );

		return buf.toString();
	}
}
