/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;

/**
 * UPLOAD エディターは、ファイルアップロードを行う場合に使用する編集用クラスです。
 *
 * ファイルアップロードで、行ごとに指定できる機能を追加します。
 * 新しいファイルを、カラム名_NEW で指定することで、事前に指定されたファイル名に
 * 強制変更後にアップロード可能です。
 * つまり、inputタグのtype="file" で指定するカラム名(例:file)と、対応する
 * 新ファイル名(例:file_NEW) を作成し、新ファイル名 を hidden 等で渡します。
 * さらに、form の送信先は、forward.jsp ではなく、実際に処理したい画面に直接
 * 送信します。これは、ファイルアップロードが、enctype="multipart/form-data"
 * のため、forward.jsp で処理できない為です。
 * ちなみに、ORACLEの場合、カラム名にFILE は使えません。これは予約語になっています。
 * 下記サンプルJSP(34CheckIn2)でも、UFILE にしています。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.8.6.0 (2006/09/29) 新規追加
 *
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_UPLOAD extends AbstractEditor {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 *
	 */
	public Editor_UPLOAD() { super(); }			// PMD:Document empty constructor 対策

	/**
	 * コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_UPLOAD( final DBColumn clm ) {
		super( clm );
		attributes.set( "type" ,"file" );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_UPLOAD( clm );
	}
}
