/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.security.HybsCryptography ;
import org.opengion.hayabusa.db.AbstractDBType;

/**
 * 半角/全角混在の一般的な制限のない暗号化された文字列を扱う為の、カラム属性を定義します。
 *
 * ログイン認証のパスワードなどは、MD5などのハッシュコードに変換する方式が使えます。
 * これは、非可逆変換なので、変換後の文字列は、元に戻すことは出来ません。
 * 一般には、この非可逆変換が使用できるのであれば、漏洩に対しては安全です。
 * このクラスの暗号化は秘密キーによる可逆変換なので、変換方式と秘密キーが判ると
 * 元に戻すことが可能です。それでも、何もしないよりははるかにましです。
 * データベース等へ登録したデータを戻して利用したいが、そのまま抜き出されるのは
 * 困る場合に、使用できます。
 * なお、暗号化するため、元データの整合性ではなく暗号化された後のデータでの整合性が
 * チェックされます。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 * @og.group データ属性
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class DBType_CRYPT extends AbstractDBType {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.6.0.3 (2012/01/24)" ;

	private final HybsCryptography licence = new HybsCryptography() ;

	/**
	 * String引数の文字列を＋１した文字列を返します。
	 * ※ このクラスでは実装されていません。
	 *
	 * @og.rev 5.6.0.3 (2012/01/24) ADD に、引数の値を加算する機能を追加します。
	 *
	 * @param   value  String引数
	 * @param   add    加算する文字列(null の場合は、従来と同じ、+1 します。)
	 *
	 * @return  引数の文字列を＋１した文字列。または、任意の値を加算した文字列。
	 * @throws UnsupportedOperationException このクラスを実行すると、必ず発生します。
	 */
	@Override
	public String valueAdd( final String value,final String add ) {
		final String errMsg = "このメソッドは、このクラスからは使用できません。";
		throw new UnsupportedOperationException( errMsg );
	}

	/**
	 * HybsCryptographyにより、暗号化された文字を返します。
	 *
	 * HybsCryptography クラスを使用した、秘密キー暗号化方式により、登録データを暗号化します。
	 * 暗号化されたバイト文字は、１６進数で文字列に変換しています。
	 *
	 * @param   value 一般に編集データとして登録されたデータ
	 *
	 * @return  修正後の文字列(一般にデータベースに登録するデータ)
	 */
	@Override
	public String valueSet( final String value ) {
		return licence.encrypt( StringUtil.rTrim( value ) );
	}
}
