<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA06"
	title	= "EXPLAIN"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:query command="{@command}" debug="{@debug}" scope="request" dbid="{@DBID}" notfoundMsg = "" maxRowCount="{@maxRowCount}">
	delete from plan_table where statement_id = '{@USER.ID}'
</og:query>

<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" dbid="{@DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
	explain plan set statement_id = '{@USER.ID}' for {@SQL}
</og:query>

<og:query command="{@command}" debug="{@debug}" notfoundMsg = "" dbid="{@DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
	<og:text>
		select LEVEL,lpad(' ',LEVEL,' ') ||
		 rtrim( operation ) || ' ' ||
		 rtrim( options )   || ' ' ||
		 rtrim( object_name ) as EXECUTION_PLAN,
		 decode( instr(options,'FULL'),null,'false',0,'false','true' ) as FULL
		from plan_table
		where statement_id = '{@USER.ID}'
		connect by prior id = parent_id
			  and statement_id = '{@USER.ID}'
		start with id = 0
			  and statement_id = '{@USER.ID}'
	</og:text>
</og:query>

<og:viewMarker command="{@command}" >
	<og:columnMarker columns="EXECUTION_PLAN" onMark="[FULL]" >
		<span id="warning">[EXECUTION_PLAN]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="EXECUTION_PLAN" renderer="PRE" scope="request" />

<og:view
	scope      = "request" 
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FULL"
	writable   = "false"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}" 
	noMessage  = "true"
/>

<og:userInfo command="SET" key="USER.LASTSQL" value="{@SQL}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
