/****************************************************************************/
/* GF85 ( 移行DB対応明細 )                                                  */
/*                                                                          */
/* Created : 2015/09/17 15:31:10                                            */
/****************************************************************************/
CREATE TABLE GF85 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , TABLE_NAME   VARCHAR2 (   50 )                   NOT NULL            /*  30 ﾃｰﾌﾞﾙ名      */
 , CLM          VARCHAR2 (   30 )                   NOT NULL            /*  40 項目         */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  50 表示順       */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  60 名称         */
 , CLS_NAME     VARCHAR2 (   10 )                   NOT NULL            /*  70 DBｸﾗｽ        */
 , USE_LENGTH   VARCHAR2 (    9 )                                       /*  80 使用桁数     */
 , DATA_DEFAULT VARCHAR2 (  200 )                                       /*  90 初期値       */
 , NOT_NULL     VARCHAR2 (    1 )                                       /* 100 ﾉｯﾄﾇﾙ        */
 , KBCLM        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 120 ｶﾗﾑ区分      */
 , BIKO         VARCHAR2 ( 2000 )                                       /* 130 備考         */
 , NOJUN        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 140 対応順       */
 , CONV_FUNC    VARCHAR2 (  500 )                                       /* 150 変換関数     */
 , F_CLM        VARCHAR2 ( 1000 )                                       /* 190 元項目       */
 , F_NAME_JA    VARCHAR2 (  200 )                                       /* 210 元名称       */
 , F_CLS_NAME   VARCHAR2 (   10 )                                       /* 220 元DBｸﾗｽ      */
 , F_USE_LENGTH VARCHAR2 (    9 )                                       /* 230 元使用桁数   */
 , F_BIKO       VARCHAR2 ( 2000 )                                       /* 240 元備考       */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /* 250 概要説明     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );

CREATE SEQUENCE GF85S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF85T00 
  BEFORE INSERT ON GF85
  FOR EACH ROW 
  BEGIN 
    SELECT GF85S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
