/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class RegistryQueryTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    private static final String[] COLUMN_KEY = new String[]{"LEBEL", "KEY", "VALUE", "CHILD", "PATH"};
    private static final String[] HKEY_TYPE = new String[]{"HKEY_CURRENT_USER", "HKEY_LOCAL_MACHINE"};
    private String tableId = "h_tblmdl";
    private String command = "NEW";
    private String baseKey;
    private String key;
    private String value;
    private int maxRowCount;
    private String orderBy;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String overflowMsg = "MSG0007";
    private String notfoundMsg = "MSG0077";
    private int maxLevel = 1;
    private boolean like;
    private int executeCount;
    private boolean isMainTrans = true;
    private int hkeyType;

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.check(this.command, COMMAND_LIST)) {
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            DBTableModel dBTableModel = this.makeDBTable();
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("RegistryQueryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(this.executeCount);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(BR);
                }
            }
            if (this.maxRowCount > 0 && this.maxRowCount <= this.executeCount) {
                stringBuilder.append(this.getResource().getLabel(this.overflowMsg));
                stringBuilder.append(BR);
            }
            this.jspPrint(stringBuilder.toString());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.orderBy = null;
        this.command = CMD_NEW;
        this.baseKey = null;
        this.key = null;
        this.value = null;
        this.executeCount = 0;
        this.maxRowCount = 0;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.overflowMsg = "MSG0007";
        this.notfoundMsg = "MSG0077";
        this.maxLevel = 1;
        this.like = false;
        this.isMainTrans = true;
        this.hkeyType = 0;
    }

    private DBTableModel makeDBTable() {
        Object object;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(COLUMN_KEY.length);
        for (int i = 0; i < COLUMN_KEY.length; ++i) {
            object = this.getResource().makeDBColumn(COLUMN_KEY[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object);
        }
        Preferences preferences = this.hkeyType == 0 ? Preferences.userRoot() : Preferences.systemRoot();
        try {
            if (!preferences.nodeExists(this.baseKey)) {
                object = "Preferences BaseKey \u304c Windows Registry \u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + HKEY_TYPE[this.hkeyType] + "\\" + preferences.absolutePath() + "]";
                throw new HybsSystemException((String)object);
            }
            this.showChild(dBTableModel, preferences.node(this.baseKey), 1);
        }
        catch (BackingStoreException backingStoreException) {
            String string = "\u30ec\u30b8\u30b9\u30c8\u30ea \u304b\u3089\u3001\u5024\u3092\u53d6\u308a\u51fa\u3059\u4e8b\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + HKEY_TYPE[this.hkeyType] + "\\" + preferences.absolutePath() + "]";
            throw new HybsSystemException(string, backingStoreException);
        }
        return dBTableModel;
    }

    private void showChild(DBTableModel dBTableModel, Preferences preferences, int n) {
        if (this.maxRowCount > 0 && this.maxRowCount <= this.executeCount) {
            return;
        }
        if (this.maxLevel > 0 && n > this.maxLevel) {
            return;
        }
        String string = null;
        try {
            String[] stringArray = preferences.childrenNames();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = stringArray[i];
                    if (this.isZenkakuName(string)) {
                        this.addTableValue(string, dBTableModel, preferences, n, null, false);
                        continue;
                    }
                    Preferences preferences2 = preferences.node(string.toLowerCase(Locale.JAPAN));
                    this.addTableValue(string, dBTableModel, preferences2, n, null, true);
                    this.showChild(dBTableModel, preferences2, n + 1);
                }
            } else {
                this.showPrefs(dBTableModel, preferences, n);
            }
        }
        catch (BackingStoreException backingStoreException) {
            String string2 = "BackingStore\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + (this.executeCount + 1) + "]" + " key=[" + string + "] " + backingStoreException.getMessage();
            System.out.println(string2);
            this.addTableValue(string, dBTableModel, preferences, n, string2, false);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "RuntimeException\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + (this.executeCount + 1) + "]" + " key=[" + string + "] " + runtimeException.getMessage();
            System.out.println(string3);
            this.addTableValue(string, dBTableModel, preferences, n, string3, false);
        }
    }

    private boolean isZenkakuName(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '\u007f') continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void showPrefs(DBTableModel dBTableModel, Preferences preferences, int n) throws BackingStoreException {
        String[] stringArray = preferences.keys();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.addTableValue(string, dBTableModel, preferences, n, null, false);
            }
        }
    }

    private void addTableValue(String string, DBTableModel dBTableModel, Preferences preferences, int n, String string2, boolean bl) {
        String string3;
        if (this.maxRowCount > 0 && this.maxRowCount <= this.executeCount) {
            return;
        }
        String string4 = string.toLowerCase(Locale.JAPAN);
        String string5 = string2 != null ? string2 : (string3 = bl ? "" : preferences.get(string4, ""));
        if (this.key != null && (this.like ? string4.indexOf(this.key) < 0 : !string4.equalsIgnoreCase(this.key))) {
            return;
        }
        if (this.value != null && (this.like ? string3.toLowerCase(Locale.JAPAN).indexOf(this.value) < 0 : !string3.equalsIgnoreCase(this.value))) {
            return;
        }
        String[] stringArray = new String[COLUMN_KEY.length];
        stringArray[0] = String.valueOf(n);
        stringArray[1] = string;
        stringArray[2] = string3;
        stringArray[3] = String.valueOf(bl);
        stringArray[4] = preferences.absolutePath();
        dBTableModel.addColumnValues(stringArray);
        ++this.executeCount;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setBaseKey(String string) {
        this.baseKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.baseKey);
    }

    public void setKey(String string) {
        this.key = StringUtil.nval((String)this.getRequestParameter(string), (String)this.key);
        if (this.key != null) {
            this.key = this.key.toLowerCase(Locale.JAPAN);
        }
    }

    public void setValue(String string) {
        this.value = StringUtil.nval((String)this.getRequestParameter(string), (String)this.value);
        if (this.value != null) {
            this.value = this.value.toLowerCase(Locale.JAPAN);
        }
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
    }

    public void setDisplayMsg(String string) {
        this.displayMsg = this.getRequestParameter(string);
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setOverflowMsg(String string) {
        this.overflowMsg = this.getRequestParameter(string);
    }

    public void setMaxLevel(String string) {
        this.maxLevel = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxLevel);
    }

    public void setLike(String string) {
        this.like = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.like);
    }

    public void setHkeyType(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            if ("user".equalsIgnoreCase(string2)) {
                this.hkeyType = 0;
            } else if ("system".equalsIgnoreCase(string2)) {
                this.hkeyType = 1;
            } else {
                String string3 = "hkeyType \u306f\u3001[user] \u304b\u3001[system] \u306e\u3069\u3061\u3089\u304b\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 hkeyType[" + string2 + "]";
                throw new HybsSystemException(string3);
            }
        }
    }

    @Override
    protected String getTagName() {
        return "regQuery";
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("baseKey", (Object)this.baseKey).println("key", (Object)this.key).println("value", (Object)this.value).println("maxRowCount", (Object)this.maxRowCount).println("orderBy", (Object)this.orderBy).println("displayMsg", (Object)this.displayMsg).println("overflowMsg", (Object)this.overflowMsg).println("maxLevel", (Object)this.maxLevel).println("like", (Object)this.like).println("executeCount", (Object)this.executeCount).println("COLUMN_KEY", (Object[])COLUMN_KEY).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

