/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

public abstract class AbstractEditor
implements CellEditor {
    private final int COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_COLUMNS_MAXSIZE");
    private final int VIEW_COLUMNS_MAXSIZE = HybsSystem.sysInt("HTML_VIEW_COLUMNS_MAXSIZE");
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    protected Attributes attributes;
    protected String name;
    protected String size1;
    protected String size2;
    protected TagBuffer tagBuffer = new TagBuffer();

    public AbstractEditor() {
    }

    protected AbstractEditor(DBColumn dBColumn) {
        this.name = dBColumn.getName();
        String string = dBColumn.isWritable() ? null : "disabled";
        int n = dBColumn.getTotalSize();
        this.attributes = new Attributes().set("type", "text").set("maxlength", String.valueOf(n)).set("disabled", string).set(dBColumn.getEditorAttributes()).add("class", dBColumn.getDbType());
        this.tagBuffer.add(this.attributes.get("optionAttributes"));
        this.size1 = String.valueOf(dBColumn.getFieldSize(this.COLUMNS_MAXSIZE));
        this.size2 = String.valueOf(dBColumn.getFieldSize(this.VIEW_COLUMNS_MAXSIZE));
    }

    @Override
    public String getValue(String string) {
        return new TagBuffer("input").add("name", this.name).add("id", this.name, StringUtil.isNull((String)this.attributes.get("id"))).add("value", string).add("size", this.size1).add(this.tagBuffer.makeTag()).makeTag();
    }

    @Override
    public String getValue(int n, String string) {
        String string2 = this.name + "__" + n;
        return new TagBuffer("input").add("name", string2).add("id", string2, StringUtil.isNull((String)this.attributes.get("id"))).add("value", string).add("size", this.size2).add(this.tagBuffer.makeTag()).makeTag(n, string);
    }
}

