/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.ServletException;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class DataCheckTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_ENTRY = "ENTRY";
    private static final String[] COMMAND_LIST = new String[]{"ENTRY", "NEW"};
    private transient DBTableModel table;
    private transient boolean isSql;
    private transient boolean isUniqCheck;
    private transient ScriptEngine jsEngine;
    private transient String bodyStr;
    private String command = "ENTRY";
    private String exist = "auto";
    private String tableId = "h_tblmdl";
    private String dbid;
    private String lbl;
    private String[] lblParamKeys;
    private boolean errRemove;
    private String sqlType;
    private String execType;
    private String conditionKey;
    private String conditionList;
    private String from;
    private String where;
    private String[] uniqCheckClms;
    private String beforeErrorJsp;
    private String afterErrorJsp;
    private boolean selectedAll;
    private boolean isExec;

    @Override
    public int doStartTag() {
        boolean bl = this.isExec = this.useTag() && (this.sqlType == null || this.execType == null || this.execType.indexOf(this.sqlType) >= 0);
        if (this.isExec) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.bodyStr = this.getBodyString();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        this.debugPrint();
        int n = 6;
        if (this.isExec && this.check(this.command, COMMAND_LIST)) {
            TransactionTag transactionTag;
            if ("notuse".equalsIgnoreCase(this.exist)) {
                return n;
            }
            this.checkParam();
            ErrMessageManager errMessageManager = new ErrMessageManager();
            errMessageManager.setTitle("Data Check Error!");
            errMessageManager.setParamKeys(this.lblParamKeys);
            errMessageManager.setResourceManager(this.getResource());
            errMessageManager.setFrom(this.from);
            try (Object object = null;){
                if (this.isSql) {
                    transactionTag = (TransactionTag)DataCheckTag.findAncestorWithClass((Tag)this, TransactionTag.class);
                    object = transactionTag == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
                }
                if (CMD_NEW.equals(this.command)) {
                    if (this.isSql) {
                        this.checkSql(this.bodyStr, errMessageManager, null, 0, "C", (Transaction)object);
                    } else {
                        this.checkJs(this.bodyStr, errMessageManager, null, 0, this.jsEngine);
                    }
                } else if (CMD_ENTRY.equals(this.command)) {
                    this.table = (DBTableModel)this.getObject(this.tableId);
                    if (this.table != null && this.table.getRowCount() > 0) {
                        errMessageManager.setDBTableModel(this.table);
                        if (this.isUniqCheck) {
                            this.checkUnique(errMessageManager);
                        } else {
                            this.checkRows(this.bodyStr, errMessageManager, (Transaction)object);
                        }
                    } else {
                        System.out.println("DBTableModel doesn't exist!! need this when command=\"ENTRY\"");
                    }
                }
            }
            transactionTag = errMessageManager.getErrMessage();
            if (transactionTag != null && !transactionTag.isOK() && !this.errRemove) {
                n = 5;
                if (this.beforeErrorJsp != null && this.beforeErrorJsp.length() > 0) {
                    this.includeJsp(this.beforeErrorJsp);
                }
                this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)transactionTag, this.getResource()));
                if (this.afterErrorJsp != null && this.afterErrorJsp.length() > 0) {
                    this.includeJsp(this.afterErrorJsp);
                }
            }
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.dbid = null;
        this.command = CMD_ENTRY;
        this.table = null;
        this.exist = "auto";
        this.errRemove = false;
        this.lbl = null;
        this.lblParamKeys = null;
        this.isSql = false;
        this.isUniqCheck = false;
        this.jsEngine = null;
        this.sqlType = null;
        this.execType = null;
        this.conditionKey = null;
        this.conditionList = null;
        this.from = null;
        this.where = null;
        this.bodyStr = null;
        this.uniqCheckClms = null;
        this.beforeErrorJsp = null;
        this.afterErrorJsp = null;
        this.selectedAll = false;
    }

    private void checkParam() {
        boolean bl = this.isUniqCheck = this.uniqCheckClms != null && this.uniqCheckClms.length > 0;
        if (this.isUniqCheck) {
            if (!CMD_ENTRY.equals(this.command)) {
                String string = "\u30e6\u30cb\u30fc\u30af\u30ad\u30fc\u30c1\u30a7\u30c3\u30af\u306f\u3001command=\"ENTRY\"\u306e\u5834\u5408\u306e\u307f\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002 command=" + this.command;
                throw new HybsSystemException(string);
            }
        } else if (this.from != null) {
            StringBuilder stringBuilder = new StringBuilder(200).append("SELECT count(*) FROM ").append(this.from);
            if (this.where != null) {
                stringBuilder.append(" WHERE ").append(this.where);
            }
            this.bodyStr = stringBuilder.toString();
            this.isSql = true;
        } else {
            if (this.bodyStr == null || this.bodyStr.isEmpty()) {
                throw new HybsSystemException("Body\u90e8\u5206\u306b\u30c1\u30a7\u30c3\u30af\u5b9a\u7fa9\u3092\u8a18\u8ff0\u3057\u3066\u4e0b\u3055\u3044\u3002");
            }
            String string = this.bodyStr.toUpperCase(Locale.JAPAN);
            if (string.indexOf("SELECT") == 0) {
                this.isSql = true;
                int n = string.indexOf("FROM");
                int n2 = string.indexOf("WHERE");
                if (n > 0 && n < n2) {
                    this.from = string.substring(n + "FROM".length(), n2).trim();
                }
            } else {
                this.jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
            }
        }
    }

    private boolean checkSql(String string, ErrMessageManager errMessageManager, String[] stringArray, int n, String string2, Transaction transaction) {
        int n2 = DBUtil.dbExist((String)string, (String[])stringArray, (Transaction)transaction, (String)this.dbid);
        boolean bl = true;
        String string3 = null;
        if (("true".equalsIgnoreCase(this.exist) || "auto".equalsIgnoreCase(this.exist) && ("C".equals(string2) || "D".equals(string2))) && n2 <= 0) {
            string3 = this.lbl == null ? "ERR0025" : this.lbl;
            bl = false;
        } else if (("false".equalsIgnoreCase(this.exist) || "auto".equalsIgnoreCase(this.exist) && "A".equals(string2)) && n2 > 0) {
            string3 = this.lbl == null ? "ERR0026" : this.lbl;
            bl = false;
        } else if ("one".equalsIgnoreCase(this.exist) && n2 > 1) {
            string3 = this.lbl == null ? "ERR0027" : this.lbl;
            bl = false;
        }
        if (!bl) {
            errMessageManager.addMessage(n, string3, stringArray);
        }
        return bl;
    }

    private boolean checkJs(String string, ErrMessageManager errMessageManager, String[] stringArray, int n, ScriptEngine scriptEngine) {
        Object object = null;
        try {
            object = scriptEngine.eval(string);
        }
        catch (ScriptException scriptException) {
            String string2 = "JavaScript\u5f0f\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
            throw new HybsSystemException(string2, scriptException);
        }
        boolean bl = false;
        if (!(object instanceof Boolean)) {
            String string3 = "JavaScript\u5f0f\u306b\u306f true \u82e5\u3057\u304f\u306f false \u304c\u8fd4\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044 Object=" + object;
            throw new HybsSystemException(string3);
        }
        bl = (Boolean)object;
        if (!bl) {
            String string4 = this.lbl == null ? "ERR0030" : this.lbl;
            errMessageManager.addMessage(n, string4, stringArray);
        }
        return bl;
    }

    private void checkRows(String string, ErrMessageManager errMessageManager, Transaction transaction) {
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return;
        }
        Formatter formatter = new Formatter((DataModel)this.table);
        formatter.setFormat(string);
        int[] nArray2 = formatter.getClmNos();
        errMessageManager.setClmNos(nArray2);
        String string2 = null;
        if (this.isSql) {
            string2 = formatter.getQueryFormatString();
        }
        int n = -1;
        if (this.conditionKey != null && this.conditionList != null) {
            n = this.table.getColumnNo(this.conditionKey);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            String string3;
            int n2 = nArray[i];
            String[] stringArray = this.getTableModelData(n2, nArray2);
            if (n >= 0 && this.conditionList.indexOf((String)this.table.getValue(n2, n)) < 0 && this.conditionList.indexOf(string3 = "|" + (String)this.table.getValue(n2, n) + "|") < 0) continue;
            if (this.isSql) {
                bl = this.checkSql(string2, errMessageManager, stringArray, n2, this.table.getModifyType(n2), transaction);
            } else {
                string3 = formatter.getFormatString(n2, "\"");
                bl = this.checkJs(string3, errMessageManager, stringArray, n2, this.jsEngine);
            }
            if (!this.errRemove || !bl) continue;
            arrayList.add(n2);
        }
        if (this.errRemove) {
            Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
            int[] nArray3 = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                nArray3[i] = integerArray[i];
            }
            this.setParameterRows(nArray3);
        }
    }

    private void checkUnique(ErrMessageManager errMessageManager) {
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[this.uniqCheckClms.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.table.getColumnNo(this.uniqCheckClms[i]);
        }
        errMessageManager.setClmNos(nArray2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String[] stringArray = this.getTableModelData(n, nArray2);
            String string = StringUtil.array2line((String[])stringArray, (String)" + ");
            if (hashMap.get(string) == null) {
                hashMap.put(string, 1);
                if (!this.errRemove) continue;
                arrayList.add(n);
                continue;
            }
            this.id = this.lbl == null ? "ERR0027" : this.lbl;
            errMessageManager.addMessage(n, this.id, stringArray);
        }
        if (this.errRemove) {
            Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
            int[] nArray3 = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                nArray3[i] = integerArray[i];
            }
            this.setParameterRows(nArray3);
        }
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setExist(String string) {
        this.exist = StringUtil.nval((String)this.getRequestParameter(string), (String)this.exist);
        if (!("auto".equalsIgnoreCase(this.exist) || "true".equalsIgnoreCase(this.exist) || "false".equalsIgnoreCase(this.exist) || "one".equalsIgnoreCase(this.exist) || "notuse".equalsIgnoreCase(this.exist))) {
            String string2 = "exist \u5c5e\u6027\u306f\u3001(auto,true,false,one,notuse)\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 [" + this.exist + "]" + CR;
            throw new HybsSystemException(string2);
        }
    }

    public void setErrRemove(String string) {
        this.errRemove = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.errRemove);
    }

    @Override
    public void setLbl(String string) {
        this.lbl = StringUtil.nval((String)this.getRequestParameter(string), (String)this.lbl);
    }

    public void setLblParamKeys(String string) {
        this.lblParamKeys = this.getCSVParameter(string);
    }

    public void setSqlType(String string) {
        this.sqlType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sqlType);
    }

    public void setExecType(String string) {
        this.execType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.execType);
    }

    public void setConditionKey(String string) {
        this.conditionKey = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setConditionList(String string) {
        this.conditionList = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (this.conditionList != null) {
            this.conditionList = "|" + this.conditionList + "|";
        }
    }

    public void setUniqCheckClms(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.uniqCheckClms = StringUtil.csv2Array((String)string2);
    }

    public void setBeforeErrorJsp(String string) {
        this.beforeErrorJsp = StringUtil.nval((String)this.getRequestParameter(string), (String)this.beforeErrorJsp);
    }

    public void setAfterErrorJsp(String string) {
        this.afterErrorJsp = StringUtil.nval((String)this.getRequestParameter(string), (String)this.afterErrorJsp);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setFrom(String string) {
        this.from = StringUtil.nval((String)this.getRequestParameter(string), (String)this.from);
    }

    public void setWhere(String string) {
        this.where = StringUtil.nval((String)this.getRequestParameter(string), (String)this.where);
    }

    private String[] getTableModelData(int n, int ... nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.table.getValue(n, nArray[i]);
        }
        return stringArray;
    }

    private void includeJsp(String string) {
        try {
            this.pageContext.include(string, false);
        }
        catch (IOException iOException) {
            String string2 = string + " \u306e include \u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 ";
            throw new HybsSystemException(string2, iOException);
        }
        catch (ServletException servletException) {
            String string3 = string + " \u306e include \u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 ";
            throw new HybsSystemException(string3, servletException);
        }
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("dbid", (Object)this.dbid).println("command", (Object)this.command).println("exist", (Object)this.exist).println("lbl", (Object)this.lbl).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static final class ErrMessageManager {
        private ResourceManager resource;
        private DBTableModel table;
        private String title;
        private String from;
        private String[] lblKeys;
        private int[] clmNo;
        private ErrorMessage errMessage;
        private String names;
        private String fromLbl;
        private String[] lblVals;
        private boolean isFirst = true;

        private ErrMessageManager() {
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setFrom(String string) {
            this.from = string;
        }

        public void setDBTableModel(DBTableModel dBTableModel) {
            this.table = dBTableModel;
        }

        public void setResourceManager(ResourceManager resourceManager) {
            this.resource = resourceManager;
        }

        public void setParamKeys(String ... stringArray) {
            this.lblKeys = stringArray;
        }

        public void setClmNos(int ... nArray) {
            this.clmNo = nArray;
        }

        private void firstExecute() {
            this.errMessage = new ErrorMessage(this.title);
            if (this.from != null) {
                this.fromLbl = this.resource.getLabel(this.from);
            }
            this.names = this.getKeysLabel(this.clmNo);
            if (this.lblKeys != null && this.lblKeys.length > 0) {
                int n = this.lblKeys.length;
                this.lblVals = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string = this.lblKeys[i];
                    if (string == null) continue;
                    this.lblVals[i] = "@KEY".equals(string) ? this.names : ("@TBL".equals(string) ? this.fromLbl : (string.startsWith("{#") && string.endsWith("}") ? this.resource.getLabel(string.substring(2, string.length() - 1)) : string));
                }
            }
        }

        private String getKeysLabel(int ... nArray) {
            StringBuilder stringBuilder = new StringBuilder(200);
            if (this.table != null && nArray.length > 0) {
                String string = this.table.getColumnName(nArray[0]);
                stringBuilder.append(this.resource.getLabel(string));
                for (int i = 1; i < nArray.length; ++i) {
                    string = this.table.getColumnName(nArray[i]);
                    stringBuilder.append(',').append(this.resource.getLabel(string));
                }
            }
            return stringBuilder.toString();
        }

        public void addMessage(int n, String string, String ... stringArray) {
            if (this.isFirst) {
                this.firstExecute();
                this.isFirst = false;
            }
            String string2 = StringUtil.array2csv((String[])stringArray);
            if (this.lblVals == null) {
                this.errMessage.addMessage(n + 1, 2, string, new String[]{this.names, string2, this.fromLbl});
            } else {
                int n2 = this.lblKeys.length;
                String[] stringArray2 = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    String string3 = this.lblVals[i];
                    if (string3 == null) continue;
                    if ("@VAL".equals(string3)) {
                        stringArray2[i] = string2;
                        continue;
                    }
                    if (string3.startsWith("[") && string3.endsWith("]")) {
                        if (this.table == null) continue;
                        stringArray2[i] = this.table.getValue(n, string3.substring(1, string3.length() - 1));
                        continue;
                    }
                    stringArray2[i] = string3;
                }
                this.errMessage.addMessage(n + 1, 2, string, stringArray2);
            }
        }

        public ErrorMessage getErrMessage() {
            return this.errMessage;
        }
    }
}

