<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2050"
	title	= "定義ファイル取込"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
>
	5.5.1.6 (2012/04/16) Takahashi Masakazu GF80変更に伴う修正(LUK,IXH,IXI,IXJ,IXK)
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select TABLE_NAME,NAME_JA,SEQNO,CLM_NAME,CLM,'' as DTYPE,CLS_NAME,
				PHY_LENGTH,USE_LENGTH,UK,LUK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,IXH,IXI,IXJ,IXK,NOT_NULL,
				RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,KBCLM,BIKO,COMMENTS,CDKH,SYSTEM_ID,TBLSYU,FGJ,UNIQ
		from GF80
	<og:where>
		<og:and value = "FGJ		in  ('0','1')"			/>
		<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"		/>
		<og:and value = "TBLSYU		= '{@TBLSYU}'"			/>
		<og:and value = "TABLE_NAME like '{@TABLE_NAME}'"	/>
		<og:and value = "NAME_JA	like '{@NAME_JA}'" 		/>
		<og:and value = "CLM		like '{@CLM}'" 			/>
		<og:and value = "CLM_NAME	like '{@CLM_NAME}'"		/>
		<og:and value = "CLS_NAME	= '{@CLS_NAME}'"		/>
		<og:and value = "RENDERER	= '{@RENDERER}'"		/>
		<og:and value = "EDITOR		= '{@EDITOR}'"			/>
		<og:and value = "DBTYPE		= '{@DBTYPE}'"			/>
		<og:and value = "NOT_NULL	= '{@NOT_NULL}'"		/>
		<og:and value = "USE_LENGTH = '{@USE_LENGTH}'"		/>
		<og:and value = "KBCLM		&lt;=  '{@KBCLM}'"		/>
		<og:and value = "CDKH		= '{@CDKH}'"			/>
		<og:and value = "BIKO		like '{@BIKO}'"			/>
		<og:and value = "COMMENTS	like '{@COMMENTS}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO" />
</og:query>

<!-- CLS_NAME,USE_LENGTH,DTYPE カラムが必須。異なる場合は、keys,vals で指定します。 -->
<og:tableFilter classId="DTYPE" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit action="COPY"	keys="noWritable"		vals="DTYPE" />
	<og:submit action="MODIFY"	keys="noWritable"		vals='"SYSTEM_ID,TABLE_NAME,CLM,DTYPE"'   />
	<og:submit action="DELETE"	keys="columnWritable"	vals="null" />

<!-- ポップアップ方式は、戻す画面が決められないので、保留
	<og:submit value="fileIn" command="VIEW" lbl="DBFILE_IN" 
		onClick="ogOpen( '{@SYS.JSP}/common/filePopup.jsp?callBack={@GUI.KEY}/fileIn.jsp&amp;useRenderer=true',event,null,'width=250px,height=50px,resizable=no',false);" />
-->
	<og:submit value="fileIn" command="VIEW" lbl="DBFILE_IN"
		onClick="location.href='{@SYS.JSP}/common/filePopup.jsp?callBack={@GUI.KEY}/fileIn.jsp&amp;useRenderer=true&amp;sheetNos=2-5&amp;nullBreakClm=TABLE_NAME&amp;omitNames=DTYPE,PHY_LENGTH,C_KEY,F_KEY&amp;debug={@debug}'; return false;" />

	<og:submit value="fileInMics" command="NEW" lbl="DBFILE_IN_MICS" />

	<og:submit value="fileInST" command="NEW" lbl="DBFILE_IN_ST" />

	<og:fieldset lbl="DeleteAll">
		<og:column name="SYSTEM_ID" defaultVal="{@LAST.SYSTEM_ID}" />
		<og:column name="TBLSYU"    value="{@TBLSYU}"    />
		<og:submit  value="deleteAll" lbl="DeleteAll" command="NEW" onClick="return confirm('{@LBL.GEM0040}');" />
	</og:fieldset>
	<og:hidden name="debug"			value="{@debug}"	/>	<!-- 6.0.2.5 (2014/10/31) Add -->
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
