/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Locale;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBMetaData;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class DBMetaDataQueryTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    public static final String ACT_SCHEMAS = "SCHEMAS";
    public static final String ACT_TABLES = "TABLES";
    public static final String ACT_COLUMNS = "COLUMNS";
    public static final String ACT_INDEXINFO = "INDEXINFO";
    public static final String ACT_PROCEDURES = "PROCEDURES";
    private static final String[] ACTION_LIST = new String[]{"SCHEMAS", "TABLES", "COLUMNS", "INDEXINFO", "PROCEDURES"};
    private String tableId = "h_tblmdl";
    private String command = "NEW";
    private String action;
    private long dyStart;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private String dbid;
    private String catalog;
    private String schema;
    private String tableName;
    private String procName;
    private String columnName;
    private boolean unique;
    private boolean approximate = true;
    private boolean isMainTrans = true;

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        if (!this.check(this.command, COMMAND_LIST)) {
            return 0;
        }
        this.useMainTrans(this.isMainTrans);
        this.startQueryTransaction(this.tableId);
        if ("session".equals(this.getScope())) {
            this.removeSessionAttribute(this.tableId);
            this.removeSessionAttribute("h_vform");
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        String string = "";
        if (this.check(this.command, COMMAND_LIST)) {
            StringBuilder stringBuilder = new StringBuilder(200);
            DBTableModel dBTableModel = this.actionExec(this.action);
            int n = dBTableModel.getRowCount();
            if (CMD_NEW.equals(this.command)) {
                if (n > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(n);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(BR);
                } else if (n == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(n));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(0));
            string = stringBuilder.toString();
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("DBMetaDataQueryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        this.jspPrint(string);
        long l = System.currentTimeMillis() - this.dyStart;
        this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.dbid = null;
        this.catalog = null;
        this.schema = null;
        this.tableName = null;
        this.procName = null;
        this.columnName = null;
        this.unique = false;
        this.approximate = true;
        this.dyStart = 0L;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.isMainTrans = true;
    }

    private DBTableModel actionExec(String string) {
        DBMetaData dBMetaData = new DBMetaData();
        dBMetaData.setDbid(this.dbid);
        dBMetaData.setResourceManager(this.getResource());
        dBMetaData.setApplicationInfo(this.getApplicationInfo());
        DBTableModel dBTableModel = null;
        if (ACT_SCHEMAS.equals(string)) {
            dBTableModel = dBMetaData.getSchemas();
        } else if (ACT_TABLES.equals(string)) {
            dBTableModel = dBMetaData.getTables(this.catalog, this.schema, this.tableName);
        } else if (ACT_COLUMNS.equals(string)) {
            dBTableModel = dBMetaData.getColumns(this.catalog, this.schema, this.tableName, this.columnName);
        } else if (ACT_INDEXINFO.equals(string)) {
            dBTableModel = dBMetaData.getIndexInfo(this.catalog, this.schema, this.tableName, this.unique, this.approximate);
        } else if (ACT_PROCEDURES.equals(string)) {
            dBTableModel = dBMetaData.getProcedures(this.catalog, this.schema, this.procName);
        }
        return dBTableModel;
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setAction(String string) {
        this.action = this.getRequestParameter(string);
        if (!this.check(this.action, ACTION_LIST)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + this.action + "] " + CR + "actionList=[" + String.join((CharSequence)", ", ACTION_LIST) + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCatalog(String string) {
        this.catalog = StringUtil.nval((String)this.getRequestParameter(string), (String)this.catalog);
    }

    public void setSchema(String string) {
        this.schema = StringUtil.nval((String)this.getRequestParameter(string), (String)this.schema);
    }

    public void setTableName(String string) {
        this.tableName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableName);
    }

    public void setProcName(String string) {
        this.procName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.procName);
    }

    public void setColumnName(String string) {
        this.columnName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columnName);
    }

    public void setUnique(String string) {
        this.unique = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.unique);
    }

    public void setApproximate(String string) {
        this.approximate = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.approximate);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    @Override
    protected String getTagName() {
        return "dbMetaDataQuery";
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("action", (Object)this.action).println("dyStart", (Object)this.dyStart).println("displayMsg", (Object)this.displayMsg).println("dbid", (Object)this.dbid).println("catalog", (Object)this.catalog).println("schema", (Object)this.schema).println("tableName", (Object)this.tableName).println("procName", (Object)this.procName).println("columnName", (Object)this.columnName).println("unique", (Object)this.unique).println("approximate", (Object)this.approximate).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

