/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.UserInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TransactionTag;

public class UserInfoTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    public static final String CMD_SET = "SET";
    public static final String CMD_GET = "GET";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_SQL = "SQL";
    public static final String CMD_NVLGET = "NVLGET";
    private static final String[] COMMAND_LIST = new String[]{"SET", "GET", "NVLGET", "REMOVE", "SQL"};
    private static final Set<String> COMMAND_SET = new HashSet<String>(Arrays.asList(COMMAND_LIST));
    private String command = "SET";
    private String key;
    private String value;
    private transient DBTableModel table;
    private String dbid;
    private String sql;
    private boolean save;

    @Override
    public int doStartTag() {
        if (this.useTag() && CMD_SQL.equals(this.command)) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        Query query = QueryFactory.newInstance();
        Object object = null;
        try {
            TransactionTag transactionTag = (TransactionTag)UserInfoTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object = transactionTag == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
            query.setTransaction(this.dbid, (Transaction)object);
            query.setResourceManager(this.getResource());
            query.setStatement(this.sql);
            query.execute(new String[0]);
            this.table = query.getDBTableModel();
        }
        finally {
            QueryFactory.close(query);
            if (object != null) {
                object.close();
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag() && this.check(this.command, COMMAND_SET)) {
            this.commandExec(this.command);
            if (CMD_GET.equals(this.command)) {
                this.jspPrint(this.value);
            } else if (CMD_NVLGET.equals(this.command)) {
                this.jspPrint(StringUtil.nval((String)this.value, (String)""));
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_SET;
        this.key = null;
        this.value = null;
        this.table = null;
        this.dbid = null;
        this.sql = null;
        this.save = false;
    }

    protected void commandExec(String string) {
        if (CMD_SQL.equals(string)) {
            this.setSQLAttribute();
        } else if (CMD_SET.equals(string)) {
            this.setAttribute();
        } else if (CMD_GET.equals(string)) {
            this.getAttribute();
        } else if (CMD_NVLGET.equals(string)) {
            this.getAttribute();
        } else if (CMD_REMOVE.equals(string)) {
            this.removeAttribute();
        }
    }

    private void setAttribute() {
        this.setUserInfo(this.key, this.value, this.save);
    }

    private void getAttribute() {
        this.value = this.getUserInfo(this.key);
    }

    private void removeAttribute() {
        UserInfo userInfo = this.getUser();
        userInfo.removeAttribute(this.key, this.save);
    }

    private void setSQLAttribute() {
        if (this.table == null || this.table.getRowCount() == 0) {
            return;
        }
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.table.getColumnName(i);
            String string2 = (String)this.table.getValue(0, i);
            this.setUserInfo(string, string2, this.save);
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setKey(String string) {
        this.key = this.getRequestParameter(string).toUpperCase(Locale.JAPAN);
        if (this.key.startsWith("USER.")) {
            this.key = this.key.substring(5);
        }
    }

    public void setValue(String string) {
        this.value = this.getRequestParameter(string);
    }

    public void setSave(String string) {
        this.save = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.save);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("key", (Object)this.key).println("value", (Object)this.value).println("dbid", (Object)this.dbid).println("sql", (Object)this.sql).println("save", (Object)this.save).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

