/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.HybsTimerTaskManager;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.html.ViewForm;
import org.opengion.hayabusa.html.ViewFormFactory;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ScheduleTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    public static final String CMD_SET = "SET";
    public static final String CMD_VIEW = "VIEW";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_CANCEL = "CANCEL";
    private static final String[] COMMAND_LIST = new String[]{"SET", "VIEW", "REMOVE", "CANCEL"};
    private static final Set<String> COMMAND_SET = new HashSet<String>(Arrays.asList(COMMAND_LIST));
    private String tableId = "h_tblmdl";
    private String command = "SET";
    private String timerTask;
    private String name;
    private String comment;
    private long delay;
    private long period = 60000L;
    private boolean fixedDelay = true;
    private int uniqKey = -1;
    private boolean singleton = true;
    private static final long FIXED_RATE_MIN_TIME = 1000L;
    private static final String TIMER_KEY = "h_timer";
    private static final String TIMERTASK_KEY = "h_timer_task";
    private String keys;
    private String vals;
    private String body;
    private String startTime = "000000";
    private String stopTime = "000000";
    private String scope = "local";
    private final int ERROR_SLEEP_TIME = HybsSystem.sysInt("REPORT_DAEMON_ERROR_SLEEP_TIME");
    private static final HybsTimerTaskManager taskManager = new HybsTimerTaskManager();

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.check(this.command, COMMAND_SET)) {
            return 6;
        }
        if ("session".equals(this.scope)) {
            this.startQueryTransaction(this.tableId);
        }
        if (this.commandExec(this.command)) {
            return 6;
        }
        this.jspPrint("ScheduleTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
        return 5;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_SET;
        this.timerTask = null;
        this.name = null;
        this.comment = null;
        this.delay = 0L;
        this.period = 60000L;
        this.fixedDelay = true;
        this.uniqKey = -1;
        this.singleton = true;
        this.keys = null;
        this.vals = null;
        this.startTime = "000000";
        this.stopTime = "000000";
        this.tableId = "h_tblmdl";
        this.scope = "local";
    }

    protected boolean commandExec(String string) {
        if (CMD_SET.equals(string)) {
            this.setAttribute();
            this.setLbl("MSG0059");
            this.jspPrint(this.getMsglbl());
        } else if (CMD_VIEW.equals(string)) {
            this.jspPrint(String.valueOf(taskManager.size()));
            this.setLbl("MSG0033");
            this.jspPrint(this.getMsglbl());
        } else if (CMD_REMOVE.equals(string)) {
            this.removeAttribute();
            this.setLbl("MSG0061");
            this.jspPrint(this.getMsglbl());
        } else if (CMD_CANCEL.equals(string)) {
            this.cancelAttribute();
            this.setLbl("MSG0063");
            this.jspPrint(this.getMsglbl());
        }
        return this.viewAttribute();
    }

    private void setAttribute() {
        Timer timer;
        if (this.singleton && taskManager.contains(this.name)) {
            return;
        }
        Map<String, String> map = this.getCSVParameter(this.keys, this.vals);
        HybsTimerTask hybsTimerTask = (HybsTimerTask)HybsSystem.newInstance(this.timerTask);
        taskManager.addTask(hybsTimerTask);
        hybsTimerTask.setName(this.name);
        hybsTimerTask.setComment(this.comment);
        hybsTimerTask.setParameter(map);
        hybsTimerTask.setBody(this.body);
        hybsTimerTask.setStartTime(this.startTime);
        hybsTimerTask.setStopTime(this.stopTime);
        hybsTimerTask.setErrorSleepSec(this.ERROR_SLEEP_TIME);
        hybsTimerTask.initDaemon();
        HashMap<String, Timer> hashMap = (HashMap<String, Timer>)this.getContextAttribute(TIMER_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, Timer>();
        }
        if ((timer = (Timer)hashMap.get(this.name)) == null) {
            timer = new Timer(true);
        }
        if (this.fixedDelay) {
            if (this.period > 0L) {
                timer.schedule((TimerTask)hybsTimerTask, this.delay, this.period);
            } else {
                timer.schedule((TimerTask)hybsTimerTask, this.delay);
            }
        } else {
            if (this.period < 1000L) {
                this.period = 1000L;
            }
            timer.scheduleAtFixedRate((TimerTask)hybsTimerTask, this.delay, this.period);
        }
        hashMap.put(this.name, timer);
        this.setContextAttribute(TIMER_KEY, hashMap);
    }

    private boolean viewAttribute() {
        HybsTimerTask[] hybsTimerTaskArray = taskManager.toArray();
        DBTableModel dBTableModel = this.makeDBTable(hybsTimerTaskArray);
        if ("local".equals(this.scope)) {
            if (dBTableModel != null) {
                ViewForm viewForm = ViewFormFactory.newInstance("HTMLTable");
                viewForm.clear();
                viewForm.init(dBTableModel);
                this.jspPrint(viewForm.create());
            }
        } else {
            super.setScope(this.scope);
            return this.commitTableObject(this.tableId, dBTableModel);
        }
        return true;
    }

    private void removeAttribute() {
        if (this.uniqKey >= 0) {
            taskManager.cancelTask(this.uniqKey);
        } else {
            taskManager.cancelTask(this.name);
        }
    }

    private void cancelAttribute() {
        taskManager.clear();
        Map map = (Map)this.getContextAttribute(TIMER_KEY);
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ((Timer)iterator.next()).cancel();
            }
            map.clear();
        }
        this.removeContextAttribute(TIMER_KEY);
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command);
    }

    public void setTimerTask(String string) {
        this.timerTask = this.getRequestParameter(string);
    }

    public void setName(String string) {
        this.name = this.getRequestParameter(string);
    }

    public void setComment(String string) {
        this.comment = this.getRequestParameter(string);
    }

    public void setDelay(String string) {
        this.delay = StringUtil.nval((String)this.getRequestParameter(string), (long)this.delay);
    }

    public void setPeriod(String string) {
        this.period = StringUtil.nval((String)this.getRequestParameter(string), (long)this.period);
    }

    public void setFixedDelay(String string) {
        this.fixedDelay = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fixedDelay);
    }

    public void setUniqKey(String string) {
        this.uniqKey = StringUtil.nval((String)this.getRequestParameter(string), (int)this.uniqKey);
    }

    public void setSingleton(String string) {
        this.singleton = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.singleton);
    }

    public void setKeys(String string) {
        this.keys = string;
    }

    public void setVals(String string) {
        this.vals = string;
    }

    public void setStartTime(String string) {
        this.startTime = StringUtil.nval((String)this.getRequestParameter(string), (String)this.startTime);
    }

    public void setStopTime(String string) {
        this.stopTime = StringUtil.nval((String)this.getRequestParameter(string), (String)this.stopTime);
    }

    private DBTableModel makeDBTable(HybsTimerTask ... hybsTimerTaskArray) {
        String[] stringArray;
        int n;
        if (hybsTimerTaskArray == null || hybsTimerTaskArray.length == 0) {
            return null;
        }
        ResourceManager resourceManager = this.getResource();
        String[] stringArray2 = new String[]{"TaskName", "UniqKey", "Comment", "CreateTime", "scheduledTime"};
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(stringArray2.length);
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray = resourceManager.makeDBColumn(stringArray2[n]);
            dBTableModel.setDBColumn(n, (DBColumn)stringArray);
        }
        for (n = 0; n < hybsTimerTaskArray.length; ++n) {
            stringArray = new String[stringArray2.length];
            stringArray[0] = hybsTimerTaskArray[n].getName();
            stringArray[1] = String.valueOf(hybsTimerTaskArray[n].getUniqKey());
            stringArray[2] = hybsTimerTaskArray[n].getComment();
            stringArray[3] = HybsSystem.getDate(hybsTimerTaskArray[n].getCreateTime());
            stringArray[4] = HybsSystem.getDate(hybsTimerTaskArray[n].scheduledExecutionTime());
            dBTableModel.addColumnValues(stringArray);
        }
        return dBTableModel;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    @Override
    public void setScope(String string) {
        this.scope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.scope);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("timerTask", (Object)this.timerTask).println("name", (Object)this.name).println("comment", (Object)this.comment).println("delay", (Object)this.delay).println("period", (Object)this.period).println("fixedDelay", (Object)this.fixedDelay).println("uniqKey", (Object)this.uniqKey).println("singleton", (Object)this.singleton).println("FIXED_RATE_MIN_TIME", (Object)1000L).println("TIMER_KEY", (Object)TIMER_KEY).println("TIMERTASK_KEY", (Object)TIMERTASK_KEY).println("keys", (Object)this.keys).println("vals", (Object)this.vals).println("body", (Object)this.body).println("startTime", (Object)this.startTime).println("stopTime", (Object)this.stopTime).println("scope", (Object)this.scope).println("ERROR_SLEEP_TIME", (Object)this.ERROR_SLEEP_TIME).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static {
        SystemManager.addCleanable((Cleanable)taskManager, true);
    }
}

