/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class CookieTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.4.0 (2015/08/01)";
    private static final long serialVersionUID = 634020150801L;
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String ACT_SAVE = "SAVE";
    public static final String ACT_LOAD = "LOAD";
    public static final String ACT_DELETE = "DELETE";
    private static final String[] ACTION_LIST = new String[]{"SAVE", "LOAD", "DELETE"};
    private static final Set<String> ACTION_SET = new HashSet<String>(Arrays.asList(ACTION_LIST));
    private String action;
    private String[] keys;
    private String[] vals;
    private String[] aliasNames;
    private String path = "/" + HybsSystem.sys("CONTEXT_NAME");
    private String domain;
    private int maxAge = -1;
    private boolean useBase64;

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.actionExec(this.action);
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.action = null;
        this.keys = null;
        this.vals = null;
        this.aliasNames = null;
        this.path = "/" + HybsSystem.sys("CONTEXT_NAME");
        this.domain = null;
        this.maxAge = -1;
        this.useBase64 = false;
    }

    private void actionExec(String string) {
        if (ACT_SAVE.equals(string)) {
            this.saveCookies(this.maxAge);
        } else if (ACT_LOAD.equals(string)) {
            this.loadCookies();
        } else if (ACT_DELETE.equals(string)) {
            this.saveCookies(0);
        } else {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + string + "] " + CR + "actionList=" + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    private void saveCookies(int n) {
        for (int i = 0; i < this.keys.length; ++i) {
            String string = StringUtil.nval((String)this.vals[i], (String)"");
            if (this.useBase64 && string.length() > 0) {
                byte[] byArray = Base64.encodeBase64((byte[])string.getBytes(DEFAULT_CHARSET));
                string = new String(byArray, DEFAULT_CHARSET);
            }
            this.setCookie(this.keys[i], string, n);
        }
    }

    private void loadCookies() {
        if (this.aliasNames == null) {
            this.aliasNames = this.keys;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            String string = this.getCookie(this.keys[i]);
            if (this.useBase64 && string != null && string.length() > 0) {
                byte[] byArray = Base64.decodeBase64((byte[])string.getBytes(DEFAULT_CHARSET));
                string = new String(byArray, DEFAULT_CHARSET);
            }
            if (string == null) continue;
            this.setRequestAttribute(this.aliasNames[i], string);
        }
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (!this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + this.action + "] " + CR + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setAliasNames(String string) {
        this.aliasNames = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setPath(String string) {
        this.path = StringUtil.nval((String)this.getRequestParameter(string), (String)this.path);
    }

    public void setDomain(String string) {
        this.domain = StringUtil.nval((String)this.getRequestParameter(string), (String)this.domain);
    }

    public void setMaxAge(String string) {
        this.maxAge = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxAge);
    }

    public void setUseBase64(String string) {
        this.useBase64 = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBase64);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("action", (Object)this.action).println("keys", (Object[])this.keys).println("vals", (Object[])this.vals).println("aliasNames", (Object[])this.aliasNames).println("path", (Object)this.path).println("domain", (Object)this.domain).println("maxAge", (Object)this.maxAge).println("useBase64", (Object)this.useBase64).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

