<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE"
	pgid     = "TRANS01"
	title    = "伝送定義"
	date     = "2008/10/14"
	author   = "M.Takahashi"
	text     = "新規作成"
	version  = "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->

<og:equals val1="INSERT|COPY|MODIFY" val2="{@sqlType}" contains="true">
<og:dataCheck command="{@command}" exist="false">
		select count(*) from GE62
		where SYSTEM_ID=[SYSTEM_ID] AND KBREAD=[KBREAD] AND READOBJ=[READOBJ] AND KBEXEC=[KBEXEC] AND EXECOBJ=[EXECOBJ] AND UNIQ != NVL([UNIQ],0) AND FGJ='1'
</og:dataCheck>
</og:equals>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
	<og:tableUpdateParam
		sqlType  = "{@sqlType}"
		table  = "GE62"
		where  = "UNIQ = [UNIQ]"
		logicalDelete = "true"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
