/*!
 * 検索部(frame name が "QUERY") の blockUI
 *
 */

jQuery(function ($) {

	// 検索中レイヤーの表示
	$.fnblockUI = function fnblockUI() {
		$.blockUI(
			{
				message: '検索中です・・・',
				css: {
					border: 'none',
					padding: '10px',
					backgroundColor: '#333',
					opacity: 0.8,
					color: '#fff'
				},
				overlayCSS: {
					backgroundColor: '#000',
					opacity: 0.6
				},
				onOverlayClick: $.unblockUI
			}
		);
	};

	// 検索中レイヤーの破棄
	$.fnUnblockUI = function fnUnblockUI() {
		$.unblockUI();
	};

	// GETパラメータ取得関数
	function getParam(key) {
		var url			= location.href;
		var parameters	= url.split("?");
		var params		= parameters[1].split("&");
		var paramsArray = [];
		var neet		= [];
		// GETパラメータをすべて取得
		for ( i = 0; i < params.length; i++ ) {
			neet = params[i].split("=");
			paramsArray.push(neet[0]);
			paramsArray[neet[0]] = neet[1];
		}
		// 引数キーに指定のパラメータの値を戻す
		return paramsArray[key];
	};

	// ボタンをクリックした場合
	$(":button[type=submit]").click(
		function() {
			$.fnblockUI();
		}
	);

	// GETパラメータの"command"が"NEW"でかつ戻り画面IDが未設定以外の場合、もしくは"command"が"RENEW"の場合
	if ((getParam("command") == "NEW" && getParam("BACK_GAMENID") != undefined) || getParam("command") == "RENEW"){
		$.fnblockUI();
	}

});
