/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsDateUtil;

public final class AccessStopFilter
implements Filter {
    private static boolean stopFilter;
    private String startTime = "230000";
    private String stopTime = "070000";
    private String filename;
    private int startStop;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isStop(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[UTF-8]", unsupportedEncodingException);
                catch (IOException iOException) {
                    String string = "\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.filename + "]";
                    throw new RuntimeException(string, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)bufferedReader);
    }

    public void init(FilterConfig filterConfig) {
        ServletContext servletContext = filterConfig.getServletContext();
        String string = servletContext.getRealPath("") + File.separator;
        this.startTime = filterConfig.getInitParameter("startTime");
        this.stopTime = filterConfig.getInitParameter("stopTime");
        this.filename = string + filterConfig.getInitParameter("filename");
        this.startStop = this.startTime == null || this.stopTime == null ? 0 : this.startTime.compareTo(this.stopTime);
    }

    public void destroy() {
    }

    private boolean isStop(ServletRequest servletRequest) {
        String string = ((HttpServletRequest)servletRequest).getRemoteUser();
        if ("SYSTEM".equalsIgnoreCase(string) || "admin".equalsIgnoreCase(string)) {
            return false;
        }
        String string2 = HybsDateUtil.getDate((String)"HHmmss");
        boolean bl = stopFilter;
        if (this.startStop < 0) {
            if (this.startTime.compareTo(string2) < 0 && string2.compareTo(this.stopTime) < 0) {
                bl = true;
            }
        } else if (this.startStop > 0 && (this.startTime.compareTo(string2) < 0 || string2.compareTo(this.stopTime) < 0)) {
            bl = true;
        }
        return bl;
    }

    public static void setStopFilter(boolean bl) {
        stopFilter = bl;
    }

    public static boolean isStopFilter() {
        return stopFilter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("AccessStopFilter").append('[').append(this.startTime).append("],").append('[').append(this.stopTime).append("],").append('[').append(this.filename).append("],");
        return stringBuilder.toString();
    }
}

