/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.7.2 (2014/06/20)";
    private static final long serialVersionUID = 577220140620L;
    public static final String ACT_CANREAD = "canRead";
    public static final String ACT_CANWRITE = "canWrite";
    public static final String ACT_CREATENEWFILE = "createNewFile";
    public static final String ACT_DELETE = "delete";
    public static final String ACT_EXISTS = "exists";
    public static final String ACT_ISDIRECTORY = "isDirectory";
    public static final String ACT_ISFILE = "isFile";
    public static final String ACT_ISHIDDEN = "isHidden";
    public static final String ACT_MKDIR = "mkdir";
    public static final String ACT_MKDIRS = "mkdirs";
    public static final String ACT_RENAMETO = "renameTo";
    public static final String ACT_READ = "read";
    public static final String ACT_EXISTSLENGTH = "existsLength";
    public static final String ACT_COPY = "copy";
    private static final String[] ACTION_LIST = new String[]{"canRead", "canWrite", "createNewFile", "delete", "exists", "isDirectory", "isFile", "isHidden", "mkdir", "mkdirs", "renameTo", "read", "existsLength", "copy"};
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String file1 = "";
    private String file2 = null;
    private String action = null;
    private boolean rtnCode = false;
    private boolean notEquals = false;
    private boolean useStop = true;
    private String encode = null;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            try {
                this.rtnCode = this.notEquals ^ this.actionExec(this.action);
            }
            catch (IOException iOException) {
                String string = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + HybsSystem.CR + "action=[" + this.action + "] , " + "  fileURL=[" + this.fileURL + "]" + "  file1=[" + this.file1 + "]" + "  file2=[" + this.file2 + "]";
                throw new HybsSystemException(string, iOException);
            }
            if (this.rtnCode) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            return this.useStop && !this.rtnCode ? 5 : 6;
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.file1 = "";
        this.file2 = null;
        this.action = null;
        this.rtnCode = false;
        this.notEquals = false;
        this.useStop = true;
        this.encode = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean actionExec(String string) throws IOException {
        String string2 = HybsSystem.url2dir(this.fileURL);
        File file = new File(StringUtil.urlAppend((String)string2, (String)this.file1, (String[])new String[0]));
        boolean bl = false;
        if (string != null) {
            if (ACT_CANREAD.equalsIgnoreCase(string)) {
                return file.canRead();
            }
            if (ACT_CANWRITE.equalsIgnoreCase(string)) {
                return file.canWrite();
            }
            if (ACT_CREATENEWFILE.equalsIgnoreCase(string)) {
                return file.createNewFile();
            }
            if (ACT_DELETE.equalsIgnoreCase(string)) {
                return file.delete();
            }
            if (ACT_EXISTS.equalsIgnoreCase(string)) {
                return file.exists();
            }
            if (ACT_ISDIRECTORY.equalsIgnoreCase(string)) {
                return file.isDirectory();
            }
            if (ACT_ISFILE.equalsIgnoreCase(string)) {
                return file.isFile();
            }
            if (ACT_ISHIDDEN.equalsIgnoreCase(string)) {
                return file.isHidden();
            }
            if (ACT_MKDIR.equalsIgnoreCase(string)) {
                if (!file.isDirectory()) return file.mkdir();
                return true;
            }
            if (ACT_MKDIRS.equalsIgnoreCase(string)) {
                return file.mkdirs();
            }
            if (ACT_RENAMETO.equalsIgnoreCase(string)) {
                if (this.file2 == null) return bl;
                File file2 = new File(StringUtil.urlAppend((String)string2, (String)this.file2, (String[])new String[0]));
                if (!file2.exists()) return file.renameTo(file2);
                if (file2.delete()) return file.renameTo(file2);
                String string3 = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]";
                throw new RuntimeException(string3);
            }
            if (ACT_READ.equalsIgnoreCase(string)) {
                if (file.isFile()) {
                    FileString fileString = new FileString();
                    fileString.setFilename(StringUtil.urlAppend((String)string2, (String)this.file1, (String[])new String[0]));
                    if (this.encode != null) {
                        fileString.setEncode(this.encode);
                    }
                    String string4 = fileString.getValue();
                    this.jspPrint(StringUtil.nval((String)this.getRequestParameter(string4), (String)""));
                    return true;
                }
                String string5 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + HybsSystem.CR + "action=[" + string + "] , " + "  fileURL=[" + this.fileURL + "]" + "  directory=[" + string2 + "]" + "  file1=[" + this.file1 + "]";
                throw new HybsSystemException(string5);
            }
            if (ACT_EXISTSLENGTH.equalsIgnoreCase(string)) {
                if (!file.exists()) return false;
                if (file.length() <= 0L) return false;
                return true;
            }
            if (!ACT_COPY.equalsIgnoreCase(string)) return bl;
            if (this.file2 == null) return bl;
            File file3 = new File(StringUtil.urlAppend((String)string2, (String)this.file2, (String[])new String[0]));
            if (file.isFile()) {
                return FileUtil.copy((File)file, (File)file3);
            }
            if (file.isDirectory()) {
                return FileUtil.copyDirectry((File)file, (File)file3);
            }
            if (file.exists()) return bl;
            String string6 = "copy\u5143(file1)\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + HybsSystem.CR + "action=[" + string + "] , " + "  fileURL=[" + this.fileURL + "]" + "  directory=[" + string2 + "]" + "  file1=[" + this.file1 + "]" + "  file2=[" + this.file2 + "]";
            throw new HybsSystemException(string6);
        }
        String string7 = "\u30a2\u30af\u30b7\u30e7\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3 NULL \u30a8\u30e9\u30fc" + HybsSystem.CR + "  file=[" + this.file1 + "]";
        throw new HybsSystemException(string7);
    }

    public void setAction(String string) {
        this.action = this.getRequestParameter(string);
        if (!this.check(this.action, ACTION_LIST)) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc");
            stringBuilder.append(HybsSystem.CR);
            stringBuilder.append("action=[").append(this.action).append("] ");
            stringBuilder.append(HybsSystem.CR);
            for (int i = 0; i < ACTION_LIST.length; ++i) {
                stringBuilder.append(" | ");
                stringBuilder.append(ACTION_LIST[i]);
            }
            stringBuilder.append(" | ");
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFile1(String string) {
        this.file1 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file1);
    }

    public void setFile2(String string) {
        this.file2 = StringUtil.nval((String)this.getRequestParameter(string), (String)this.file2);
    }

    public void setNotEquals(String string) {
        this.notEquals = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.notEquals);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("fileURL", (Object)this.fileURL).println("file1", (Object)this.file1).println("file2", (Object)this.file2).println("action", (Object)this.action).println("rtnCode", (Object)this.rtnCode).println("notEquals", (Object)this.notEquals).println("useStop", (Object)this.useStop).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

