/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelEditor;
import org.opengion.hayabusa.db.DBTableModelImpl;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.ResourceManager;

public final class DBTableModelUtil {
    private DBTableModelUtil() {
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo) {
        return DBTableModelUtil.makeDBTable(string, stringArray, resourceManager, applicationInfo, null);
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        DBTableModel dBTableModel = null;
        Query query = QueryFactory.newInstance("JDBCPrepared");
        ErrorMessage errorMessage = null;
        TransactionReal transactionReal = null;
        try {
            transactionReal = new TransactionReal(applicationInfo);
            query.setTransaction(string2, (Transaction)transactionReal);
            query.setResourceManager(resourceManager);
            query.setStatement(string);
            query.execute(stringArray);
            int n = query.getErrorCode();
            int n2 = query.getExecuteCount();
            if (n < 2 && n2 >= 0) {
                dBTableModel = query.getDBTableModel();
                if (query.isUpdate()) {
                    query.commit();
                }
            } else {
                errorMessage = query.getErrorMessage();
            }
        }
        catch (HybsSystemException hybsSystemException) {
            if (query != null) {
                query.rollback();
            }
            throw hybsSystemException;
        }
        finally {
            QueryFactory.close(query);
            if (transactionReal != null) {
                transactionReal.close();
            }
        }
        if (errorMessage != null) {
            throw new HybsSystemException(errorMessage.toString());
        }
        return dBTableModel;
    }

    public static DBTableModel newDBTable() {
        return new DBTableModelImpl();
    }

    public static DBTableModel makeDBTable(String[] stringArray, String[][] stringArray2, ResourceManager resourceManager) {
        int n;
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0 || stringArray2[0] == null || stringArray2[0].length == 0) {
            return null;
        }
        if (stringArray.length != stringArray2[0].length) {
            String string = "\u30ad\u30fc\u306e\u30ab\u30e9\u30e0\u6570\u3068\u30c7\u30fc\u30bf\u306e\u30ab\u30e9\u30e0\u6570\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + HybsSystem.CR + " clms.length=[" + stringArray.length + "]  vals.length=[" + stringArray2[0].length + "]" + " clms=" + StringUtil.array2csv((String[])stringArray) + HybsSystem.CR + " vals=" + StringUtil.array2csv((String[])stringArray2[0]);
            throw new HybsSystemException(string);
        }
        int n2 = stringArray.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n2);
        DBColumn[] dBColumnArray = new DBColumn[n2];
        for (n = 0; n < n2; ++n) {
            dBColumnArray[n] = resourceManager.makeDBColumn(stringArray[n]);
            dBTableModel.setDBColumn(n, dBColumnArray[n]);
        }
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel.addColumnValues(stringArray2[i]);
        }
        return dBTableModel;
    }

    public static DBTableModel makeDBTable(ResultSet resultSet, int n, int n2, ResourceManager resourceManager) throws SQLException {
        int n3;
        String[] stringArray;
        int n4;
        if (resultSet == null || resourceManager == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n5 = resultSetMetaData.getColumnCount();
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n5);
        DBColumn[] dBColumnArray = new DBColumn[n5];
        boolean bl = false;
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            stringArray = resultSetMetaData.getColumnLabel(n4 + 1).toUpperCase(Locale.JAPAN);
            dBColumnArray[n4] = resourceManager.getDBColumn((String)stringArray);
            if (dBColumnArray[n4] == null) {
                LabelData labelData = resourceManager.getLabelData((String)stringArray);
                dBColumnArray[n4] = DBTableModelUtil.makeDBColumn((String)stringArray, labelData, resultSetMetaData, n4, resourceManager.getLang());
            }
            dBTableModel.setDBColumn(n4, dBColumnArray[n4]);
            nArray[n4] = n3 = resultSetMetaData.getColumnType(n4 + 1);
            if (n3 != 2005 && n3 != -8 && n3 != 93) continue;
            bl = true;
        }
        for (n4 = 0; n4 < n && resultSet.next(); ++n4) {
        }
        n4 = 0;
        if (bl) {
            while (n4 < n2 && resultSet.next()) {
                ++n4;
                stringArray = new String[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    stringArray[n3] = DBUtil.getValue((ResultSet)resultSet, (int)n3, (int)nArray[n3]);
                }
                dBTableModel.addColumnValues(stringArray);
            }
        } else {
            while (n4 < n2 && resultSet.next()) {
                ++n4;
                stringArray = new String[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    Object object = resultSet.getObject(n3 + 1);
                    stringArray[n3] = object == null ? "" : String.valueOf(object);
                }
                dBTableModel.addColumnValues(stringArray);
            }
        }
        if (n4 >= n2 && resultSet.next()) {
            dBTableModel.setOverflow(true);
        }
        return dBTableModel;
    }

    public static DBTableModel makeEditDBTable(ResultSet resultSet, int n, int n2, ResourceManager resourceManager, DBEditConfig dBEditConfig) throws SQLException {
        if (resultSet == null || resourceManager == null) {
            return null;
        }
        DBTableModelEditor dBTableModelEditor = new DBTableModelEditor();
        dBTableModelEditor.create(resultSet, n, n2, resourceManager, dBEditConfig);
        return dBTableModelEditor;
    }

    public static DBColumn makeDBColumn(String string, LabelData labelData, ResultSetMetaData resultSetMetaData, int n, String string2) {
        DBColumn dBColumn;
        try {
            String string3 = DBTableModelUtil.type2ClassName(resultSetMetaData.getColumnType(n + 1));
            int n2 = resultSetMetaData.getColumnDisplaySize(n + 1);
            if (n2 == 0) {
                n2 = 60;
            }
            boolean bl = resultSetMetaData.isWritable(n + 1);
            String string4 = "NUMBER".equals(string3) ? "S9" : "XK";
            String string5 = "NUMBER".equals(string3) ? "0" : "";
            DBColumnConfig dBColumnConfig = new DBColumnConfig(string2, string, labelData, string3, String.valueOf(n2), String.valueOf(bl), null, null, null, string4, string5, null, null, null, null, false, null);
            dBColumn = new DBColumn(dBColumnConfig);
        }
        catch (SQLException sQLException) {
            String string6 = "DBColumn \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002name=[" + string + " , label=[" + labelData + "]";
            throw new HybsSystemException(string6, sQLException);
        }
        catch (RuntimeException runtimeException) {
            String string7 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002name=[" + string + " , label=[" + labelData + "]";
            throw new HybsSystemException(string7, runtimeException);
        }
        return dBColumn;
    }

    private static String type2ClassName(int n) {
        String string;
        switch (n) {
            case -7: 
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "NUMBER";
                break;
            }
            case 91: 
            case 93: {
                string = "DATE";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }
}

