<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command = "{@command}" dbid="RESOURCE" maxRowCount="{@maxRowCount}">
		select 
			TITLE,PARAM_ID,PARAM,CONTENTS,PARAM_LVL,UNIQ
		from GE12
		where SYSTEM_ID = '{@SYS.SYSTEM_ID}'
		and CONTXT_PATH = '**'
		and KBSAKU = '1'
		and FGJ = '1'
	<og:where startKey="and">
		<og:and value = "PARAM_ID	like	'{@PARAM_ID}%'"		/>
		<og:and value = "PARAM		like	'{@PARAM}%'" 		/>
		<og:and value = "TITLE		like	'{@TITLE}%'"		/>
		<og:and value = "PARAM_LVL	=		'{@PARAM_LVL}'"		/>
		<og:and value = "CONTENTS	like	'{@CONTENTS}%'"		/>
	</og:where>
		order by PARAM_ID,SEQNO,UNIQ
</og:query>


<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="PARAM" onMark="PASS" markList="[PARAM_ID]" >
		<span>****</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_ID" onMark="[PARAM_LVL]" markList="5" >
		<span style="background-color:#ccff00">[PARAM_ID]</span>
	</og:columnMarker>
	<og:columnMarker column="PARAM_LVL" onMark="[PARAM_LVL]" markList="012" >
		<span style="background-color:#ff66cc">[PARAM_LVL]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="PARAM" must="true" />
<og:columnEditor column="CONTENTS" renderer="PRE" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="columnWritable" vals="PARAM" />
</og:writeCheck>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
>
<jsp:directive.include file="view.jsp" />
</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
