/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.POIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class ExcelReader_XSSF {
    private static final String VERSION = "6.0.3.0 (2014/11/13)";
    private static final String CR = System.getProperty("line.separator");
    public static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excelReader(String string, ExcelReaderEvent excelReaderEvent) {
        OPCPackage oPCPackage = null;
        try {
            oPCPackage = OPCPackage.open((String)string);
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            String[] stringArray = ExcelReader_XSSF.getSheetNames(xSSFReader);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER);
            SharedStringsTable sharedStringsTable = xSSFReader.getSharedStringsTable();
            SheetHandler sheetHandler = new SheetHandler(sharedStringsTable, excelReaderEvent);
            xMLReader.setContentHandler(sheetHandler);
            InputStream inputStream = null;
            for (int i = 0; i < stringArray.length; ++i) {
                excelReaderEvent.startSheet(stringArray[i], i);
                try {
                    inputStream = xSSFReader.getSheet("rId" + (i + 1));
                    InputSource inputSource = new InputSource(inputStream);
                    xMLReader.parse(inputSource);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(inputStream);
                    throw throwable;
                }
                Closer.ioClose(inputStream);
                excelReaderEvent.endSheet(i);
            }
        }
        catch (Exception exception) {
            String string2 = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + string + "\n" + exception.getMessage();
            throw new RuntimeException(string2, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSheetNames(XSSFReader xSSFReader) throws SAXException, IOException, InvalidFormatException {
        final ArrayList arrayList = new ArrayList();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER);
        xMLReader.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if ("sheet".equals(string3)) {
                    String string4 = attributes.getValue("name");
                    arrayList.add(string4);
                }
            }
        });
        InputStream inputStream = null;
        try {
            inputStream = xSSFReader.getWorkbookData();
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        finally {
            Closer.ioClose(inputStream);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.util.ExcelReader_XSSF \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        String string = stringArray[0];
        ExcelReader_XSSF.excelReader(string, new ExcelReaderEvent(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class SheetHandler
    extends DefaultHandler {
        private final SharedStringsTable sst;
        private final ExcelReaderEvent event;
        private String lastContents;
        private boolean isSST;
        private int rowNo = -1;
        private int colNo = -1;
        private boolean isRowSkip = false;

        private SheetHandler(SharedStringsTable sharedStringsTable, ExcelReaderEvent excelReaderEvent) {
            this.sst = sharedStringsTable;
            this.event = excelReaderEvent;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("row".equals(string3)) {
                this.rowNo = Integer.parseInt(attributes.getValue("r")) - 1;
                this.isRowSkip = false;
            } else {
                if (this.isRowSkip) {
                    return;
                }
                if ("c".equals(string3)) {
                    String string4 = attributes.getValue("r");
                    int[] nArray = POIUtil.kigo2rowCol(string4);
                    this.colNo = nArray[1];
                    this.isSST = "s".equals(attributes.getValue("t"));
                }
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.isRowSkip = this.event.isSkip(this.rowNo);
            if (this.isRowSkip) {
                return;
            }
            if ("v".equals(string3)) {
                if (this.isSST) {
                    int n = Integer.parseInt(this.lastContents);
                    this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(n)).toString();
                    this.isSST = false;
                }
                this.event.value(this.lastContents, this.rowNo, this.colNo);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.isRowSkip) {
                return;
            }
            this.lastContents = this.lastContents + new String(cArray, n, n2);
        }
    }
}

