/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsDateUtil;

public class ResultSetValue {
    private static final String CR = System.getProperty("line.separator");
    private final ResultSet resultSet;
    private final int clmSize;
    private final String[] names;
    private final int[] type;
    private final boolean useObj;
    private final int[] size;
    private final boolean[] isWrit;

    public ResultSetValue(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        this.clmSize = resultSetMetaData.getColumnCount();
        this.names = new String[this.clmSize];
        this.type = new int[this.clmSize];
        this.size = new int[this.clmSize];
        this.isWrit = new boolean[this.clmSize];
        boolean bl = false;
        for (int i = 0; i < this.clmSize; ++i) {
            int n;
            this.type[i] = n = resultSetMetaData.getColumnType(i + 1);
            if (n == 2005 || n == -8 || n == 93) {
                bl = true;
            }
            this.names[i] = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
            this.size[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            this.isWrit[i] = resultSetMetaData.isWritable(i + 1);
        }
        this.useObj = bl;
    }

    public int getColumnCount() {
        return this.clmSize;
    }

    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public String getColumnName(int n) {
        return this.names[n];
    }

    public int getSqlType(int n) {
        return this.type[n];
    }

    public int[] getColumnDisplaySizes() {
        return (int[])this.size.clone();
    }

    public int getColumnDisplaySize(int n) {
        return this.size[n];
    }

    public boolean[] isWritable() {
        return (boolean[])this.isWrit.clone();
    }

    public boolean isWritable(int n) {
        return this.isWrit[n];
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public String getValue(int n) throws SQLException {
        String string;
        Object object = this.resultSet.getObject(n + 1);
        if (object == null) {
            string = "";
        } else if (this.useObj) {
            switch (this.type[n]) {
                case 2005: {
                    string = this.getClobData((Clob)object);
                    break;
                }
                case -8: {
                    string = this.resultSet.getString(n + 1);
                    break;
                }
                case 93: {
                    string = HybsDateUtil.getDate(((Timestamp)object).getTime(), "yyyyMMddHHmmss");
                    break;
                }
                default: {
                    string = String.valueOf(object);
                    break;
                }
            }
        } else {
            string = String.valueOf(object);
        }
        return string;
    }

    public String[] getValues() throws SQLException {
        String[] stringArray = new String[this.clmSize];
        for (int i = 0; i < this.clmSize; ++i) {
            stringArray[i] = this.getValue(i);
        }
        return stringArray;
    }

    public Number getNumber(int n) throws SQLException {
        Object object = this.resultSet.getObject(n + 1);
        Number number = null;
        switch (this.type[n]) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                number = (Number)object;
                break;
            }
            case 91: 
            case 92: {
                number = ((Date)object).getTime();
                break;
            }
            case 93: {
                number = ((Timestamp)object).getTime();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String string = (String)object;
                try {
                    number = Double.valueOf(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "\u6570\u5b57\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002in=" + string + CR + numberFormatException.getMessage();
                    throw new RuntimeException(string2, numberFormatException);
                }
            }
        }
        return number;
    }

    public String getClassName(int n) {
        String string;
        switch (this.type[n]) {
            case -7: 
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "NUMBER";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = "DATE";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }

    private String getClobData(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(10000);
        Reader reader = null;
        try {
            int n;
            reader = clob.getCharacterStream();
            char[] cArray = new char[10000];
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            String string = "CLOB\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(reader);
        }
        return stringBuilder.toString();
    }
}

