/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;

public class EDbid
implements Cloneable {
    private String dbidKey = "DEFAULT";
    private String title = null;
    private String url = null;
    private String user = null;
    private String password = "";
    private boolean readonly = false;
    private int mincount = 3;
    private int maxcount = 30;
    private int pooltime = 3000;
    private boolean isUseAppInfo = true;
    private boolean isParamMetaData = false;
    private String dbProductName = null;
    private String dbProductVersion = null;
    private String driverName = null;
    private String driverVersion = null;
    private final Properties props = new Properties();

    public String getDbidKey() {
        return this.dbidKey;
    }

    protected void setDbidKey(String string) {
        if (this.isNotNull(string)) {
            this.dbidKey = string.toUpperCase(Locale.JAPAN);
        }
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String string) {
        this.title = this.isNotNull(string) ? string : this.dbidKey;
    }

    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String string) {
        if (this.isNotNull(string)) {
            this.url = string;
        }
    }

    public String getUser() {
        return this.user;
    }

    protected void setUser(String string) {
        if (this.isNotNull(string)) {
            this.user = string;
        }
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String string) {
        if (this.isNotNull(string)) {
            this.password = string;
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    protected void setReadonly(String string) {
        if (this.isNotNull(string)) {
            this.readonly = Boolean.valueOf(string);
        }
    }

    public int getMincount() {
        return this.mincount;
    }

    protected void setMincount(String string) {
        if (this.isNotNull(string)) {
            this.mincount = Integer.parseInt(string);
        }
    }

    public int getMaxcount() {
        return this.maxcount;
    }

    protected void setMaxcount(String string) {
        if (this.isNotNull(string)) {
            this.maxcount = Integer.parseInt(string);
        }
    }

    public int getPooltime() {
        return this.pooltime;
    }

    protected void setPooltime(String string) {
        if (this.isNotNull(string)) {
            this.pooltime = Integer.parseInt(string);
        }
    }

    public boolean isApplicationInfo() {
        return this.isUseAppInfo;
    }

    protected void setApplicationInfo(String string) {
        if (this.isNotNull(string)) {
            this.isUseAppInfo = Boolean.valueOf(string);
        }
    }

    public void setMetaDataInfo(DatabaseMetaData databaseMetaData) throws SQLException {
        this.dbProductName = databaseMetaData.getDatabaseProductName();
        this.dbProductVersion = databaseMetaData.getDatabaseProductVersion();
        this.driverName = databaseMetaData.getDriverName();
        this.driverVersion = databaseMetaData.getDriverVersion();
        this.isUseAppInfo = this.isUseAppInfo && "ORACLE".equalsIgnoreCase(this.dbProductName);
        this.isParamMetaData = "PostgreSQL".equalsIgnoreCase(this.dbProductName);
    }

    public String getDbProductName() {
        return this.dbProductName;
    }

    public String getDbProductVersion() {
        return this.dbProductVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public boolean useParamMetaData() {
        return this.isParamMetaData;
    }

    protected void addProp(String string, String string2) {
        this.props.put(string, string2);
    }

    protected void addProp(String string) {
        if (string != null && string.indexOf(61) > 0) {
            String string2 = string.substring(0, string.indexOf(61));
            String string3 = string.substring(string.indexOf(61) + 1);
            this.addProp(string2, string3);
        }
    }

    public Properties getProps() {
        return this.props;
    }

    private boolean isNotNull(String string) {
        return string != null && !string.trim().isEmpty();
    }

    public EDbid clone() {
        try {
            return (EDbid)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            String string = "clone \u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            throw new RuntimeException(string, cloneNotSupportedException);
        }
    }

    public String info() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("DBID=[").append(this.dbidKey).append("] , ");
        stringBuilder.append("TITLE=[").append(this.title).append("] , ");
        stringBuilder.append("URL=[").append(this.url).append("] , ");
        stringBuilder.append("USER=[").append(this.user).append(']');
        stringBuilder.append(string);
        stringBuilder.append("DB Product=[").append(this.dbProductName);
        stringBuilder.append('(').append(this.dbProductVersion).append(')').append(']');
        stringBuilder.append(string);
        stringBuilder.append("DB Driver =[").append(this.driverName);
        stringBuilder.append('(').append(this.driverVersion).append(')').append(']');
        stringBuilder.append(string);
        stringBuilder.append("PROPERTIES=[").append(this.props.toString()).append(']');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.info());
        stringBuilder.append("MINCOUNT=[").append(this.mincount).append("],");
        stringBuilder.append("MAXCOUNT=[").append(this.maxcount).append("],");
        stringBuilder.append("POOLTIME=[").append(this.pooltime).append("],");
        stringBuilder.append("READONLY=[").append(this.readonly).append("],");
        stringBuilder.append("APPINFO =[").append(this.isUseAppInfo).append(']');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

