/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.text.MessageFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.LabelInterface;

public final class LabelData
implements LabelInterface {
    public static final int CLM = 0;
    public static final int SNAME = 1;
    public static final int LNAME = 2;
    public static final int DESCRIPTION = 3;
    public static final int DATA_SIZE = 4;
    public static final int FG_LOAD = 4;
    private final String key;
    private final String label;
    private final String shortLabel;
    private final String longLabel;
    private final String description;
    private final boolean official;
    private final boolean isFormat;
    private final String rawShortLabel;
    private final boolean isFormatDesc;
    private final String rawLongLabel;

    public LabelData(String string) {
        this.label = this.key = string.intern();
        this.shortLabel = this.key;
        this.longLabel = this.key;
        this.description = "";
        this.official = false;
        this.isFormat = false;
        this.rawShortLabel = this.key;
        this.isFormatDesc = false;
        this.rawLongLabel = this.key;
    }

    LabelData(String[] stringArray) {
        this.key = stringArray[0].intern();
        this.label = StringUtil.nval2((String)stringArray[2], (String)"");
        this.description = stringArray[3];
        this.official = true;
        this.isFormat = this.label.indexOf(123) >= 0;
        String string = null;
        this.rawLongLabel = this.label;
        if (this.description == null || this.description.length() == 0) {
            this.isFormatDesc = false;
            string = StringUtil.htmlFilter((String)this.label);
            this.longLabel = this.label;
        } else {
            this.isFormatDesc = this.description.indexOf(123) >= 0;
            string = StringUtil.htmlFilter((String)this.description);
            this.longLabel = "<span title=\"" + string + "\">" + this.label + "</span>";
        }
        String string2 = stringArray[1];
        if (string2 == null || string2.length() == 0) {
            this.shortLabel = this.longLabel;
            this.rawShortLabel = this.label;
        } else {
            this.shortLabel = "<span title=\"" + string + "\">" + string2 + "</span>";
            this.rawShortLabel = string2;
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public String getLongLabel() {
        return this.longLabel;
    }

    @Override
    public String getLongLabel(String string) {
        String string2 = string == null ? this.longLabel : "<span title=\"" + StringUtil.htmlFilter((String)string) + "\">" + this.label + "</span>";
        return string2;
    }

    @Override
    public String getMessage(String[] stringArray) {
        String string;
        String[] stringArray2;
        String[] stringArray3 = stringArray2 = stringArray == null ? new String[]{} : stringArray;
        if (this.isFormat) {
            string = MessageFormat.format(this.label, stringArray2);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.label);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null || stringArray2[i].equals(this.label)) continue;
                stringBuilder.append(' ').append(stringArray2[i]);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescription(String[] stringArray) {
        String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
        String string = this.isFormatDesc ? MessageFormat.format(this.description, stringArray2) : this.description;
        return string;
    }

    @Override
    public boolean isOfficial() {
        return this.official;
    }

    public String getRawLongLabel() {
        return this.rawLongLabel;
    }

    public String getRawShortLabel() {
        return this.rawShortLabel;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("CLM :").append(this.key);
        stringBuilder.append(" SNAME :").append(this.shortLabel);
        stringBuilder.append(" LNAME :").append(this.longLabel);
        stringBuilder.append(" DESCRIPTION :").append(this.description).append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

