/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.report2.ExecProcess;
import org.opengion.hayabusa.report2.ExecQueue;

public class ExecThread
extends Thread {
    private Status state = Status.EXECUTE;
    private static final int RETRY_COUNT = HybsSystem.sysInt("REPORT_RETRY_COUNT");
    private final List<ExecQueue> queues = Collections.synchronizedList(new ArrayList());
    private long threadStart = System.currentTimeMillis();
    private long execStart = 0L;
    private long execEnd = 0L;
    private final boolean debug;

    public ExecThread(String string) {
        this(string, false);
    }

    public ExecThread(String string, boolean bl) {
        this.setName(string);
        this.debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stackQueue(ExecQueue execQueue) {
        execQueue.addMsg("[INFO]QUEUE STACK:THREAD-ID=" + execQueue.getThreadId() + ",YKNO=" + execQueue.getYkno() + HybsSystem.CR);
        this.queues.add(execQueue);
        execQueue.setExecute();
        if (this.debug) {
            execQueue.addMsg("[INFO]QUEUE STACKED" + HybsSystem.CR);
        }
        ExecThread execThread = this;
        synchronized (execThread) {
            if (this.state == Status.WAIT) {
                this.interrupt();
                if (this.debug) {
                    execQueue.addMsg("[INFO]INTERRUPT" + HybsSystem.CR);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this;
            synchronized (object) {
                while (this.queues.isEmpty()) {
                    try {
                        this.state = Status.WAIT;
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.state = Status.EXECUTE;
                    }
                }
            }
            object = this.popQueue();
            if (object == null) continue;
            if ("_FINALIZE".equals(((ExecQueue)object).getYkno())) {
                if (!this.debug) break;
                ((ExecQueue)object).addMsg("[INFO]END" + HybsSystem.CR);
                break;
            }
            if (this.debug) {
                ((ExecQueue)object).addMsg("[INFO]QUEUE START" + HybsSystem.CR);
            }
            this.exec((ExecQueue)object);
            System.out.print(((ExecQueue)object).getMsg());
        }
    }

    public void finish() {
        this.queues.clear();
        ExecQueue execQueue = new ExecQueue();
        execQueue.setYkno("_FINALIZE");
        this.stackQueue(execQueue);
    }

    public void finishAfterExec() {
        ExecQueue execQueue = new ExecQueue();
        execQueue.setYkno("_FINALIZE");
        this.stackQueue(execQueue);
    }

    private void exec(ExecQueue execQueue) {
        this.execStart = System.currentTimeMillis();
        ExecProcess execProcess = new ExecProcess(execQueue, this.debug);
        for (int i = 0; i <= RETRY_COUNT; ++i) {
            try {
                while (!execQueue.isEnd()) {
                    execProcess.process();
                }
                execQueue.setComplete();
                break;
            }
            catch (Throwable throwable) {
                execQueue.addMsg("[ERROR]ERROR OCCURRED!" + HybsSystem.CR);
                execQueue.addMsg(StringUtil.stringStackTrace((Throwable)throwable));
                if (i != RETRY_COUNT) continue;
                execQueue.addMsg("[ERROR]UPTO RETRY COUNT!" + HybsSystem.CR);
                execQueue.setError();
                continue;
            }
        }
        this.execEnd = System.currentTimeMillis();
    }

    private ExecQueue popQueue() {
        return this.queues.remove(0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("STATE=").append(this.state.toString());
        stringBuilder.append(", START=").append(HybsSystem.getDate(this.threadStart));
        stringBuilder.append(", POOL=").append(this.queues.size());
        stringBuilder.append(", EXEC-START=").append(HybsSystem.getDate(this.execStart));
        stringBuilder.append(", EXEC-END=").append(HybsSystem.getDate(this.execEnd));
        stringBuilder.append(", DEBUG=").append(this.debug);
        return stringBuilder.toString();
    }

    private static enum Status {
        EXECUTE,
        WAIT;

    }
}

