/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.File;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.ExcelInsert;
import org.opengion.hayabusa.report.ProgramRun;
import org.opengion.hayabusa.report.RFIDPrintRequest;
import org.opengion.hayabusa.report.ReportConverter;
import org.opengion.hayabusa.report.ReportPrint;

public class ReportProcessing {
    private static final String FGRUN_1 = "1";
    private static final String FGRUN_2 = "2";
    private static final String FGRUN_3 = "3";
    private static final String FGRUN_5 = "5";
    private static final String FGRUN_6 = "6";
    private static final String FGRUN_7 = "7";
    private static final String FGRUN_A = "A";
    private static final String FGRUN_B = "B";
    private static final String FGRUN_C = "C";
    private static final String FGRUN_D = "D";
    private static final String CR = HybsSystem.CR;
    private final String REPORT_URL = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT/")));
    private final String EXCELIN_URL = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("EXCEL_IN_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "EXCELIN/")));
    private StringBuilder errMsg = new StringBuilder();
    private String SYSTEM_ID = null;
    private String YKNO = null;
    private String GROUPID = null;
    private String LISTID = null;
    private String JOKEN = null;
    private String OUT_DIR = null;
    private String OUT_FILE = null;
    private String outputFile = null;
    private boolean isDebug = false;
    private String FGRUN = null;
    private String PRTID = null;
    private String LANG = "ja";
    private String PRGDIR = null;
    private String PRGFILE = null;
    private String DMN_GRP = null;
    private String programFile = null;
    private static final String GE53_SELECT = "SELECT FGRUN,PRTID,LANG,PRGDIR,PRGFILE,SYSTEM_ID,DMN_GRP FROM GE53 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  JOKEN = ?";
    private static final int GE53_FGRUN = 0;
    private static final int GE53_PRTID = 1;
    private static final int GE53_LANG = 2;
    private static final int GE53_PRGDIR = 3;
    private static final int GE53_PRGFILE = 4;
    private static final int GE53_SYSTEM_ID = 5;
    private static final int GE53_DMN_GRP = 6;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public String execute() {
        boolean bl;
        System.out.println();
        System.out.println("Process Start:" + HybsSystem.getDate("yyyy/MM/dd HH:mm:ss"));
        System.out.println("  SYSTEM_ID=[" + this.SYSTEM_ID + "] YKNO=[" + this.YKNO + "] GROUPID=[" + this.GROUPID + "]");
        System.out.println("  PRTID=[" + this.PRTID + "] LISTID=[" + this.LISTID + "] JOKEN=[" + this.JOKEN + "]");
        String string = null;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportProcessing", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
        try {
            Object object;
            Object object2;
            bl = this.initialDataSet(this.appInfo);
            System.out.print("INIT=" + bl + ",");
            String string2 = this.REPORT_URL + this.SYSTEM_ID + HybsSystem.FS + this.LISTID;
            String string3 = null;
            if (bl && (this.FGRUN.equals(FGRUN_1) || this.FGRUN.equals(FGRUN_2) || this.FGRUN.equals(FGRUN_3))) {
                System.out.println("RUN_" + this.FGRUN);
                object2 = new ReportConverter(this.SYSTEM_ID, this.YKNO, this.LISTID, string2, this.LANG, this.isDebug);
                bl = ((ReportConverter)object2).initialDataSet();
                string3 = ((ReportConverter)object2).modelFile();
                if (bl && (this.FGRUN.equals(FGRUN_1) || this.FGRUN.equals(FGRUN_3))) {
                    bl = ((ReportConverter)object2).execute();
                }
                if (bl) {
                    string = FGRUN_2;
                }
                this.errMsg.append(((ReportConverter)object2).getErrMsg()).append(CR);
            }
            if (bl && (this.FGRUN.equals(FGRUN_2) || this.FGRUN.equals(FGRUN_3))) {
                System.out.println("RUN_" + this.FGRUN);
                string = null;
                object2 = new ReportPrint(this.SYSTEM_ID, this.YKNO, this.PRTID, this.programFile, string2, string3, this.outputFile, this.DMN_GRP, this.isDebug);
                bl = ((ReportPrint)object2).execute();
                if (bl) {
                    string = FGRUN_2;
                }
                this.errMsg.append(((ReportPrint)object2).getErrMsg()).append(CR);
            }
            object2 = this.EXCELIN_URL + this.SYSTEM_ID + HybsSystem.FS + this.LISTID;
            if (bl && (this.FGRUN.equals(FGRUN_5) || this.FGRUN.equals(FGRUN_7))) {
                System.out.println("RUN_" + this.FGRUN);
                object = new ExcelInsert(this.SYSTEM_ID, this.YKNO, this.LISTID, (String)object2, this.isDebug);
                bl = ((ExcelInsert)object).execute();
                if (bl) {
                    string = FGRUN_6;
                }
                this.errMsg.append(((ExcelInsert)object).getErrMsg()).append(CR);
            }
            if (bl && (this.FGRUN.equals(FGRUN_6) || this.FGRUN.equals(FGRUN_7))) {
                System.out.println("RUN_" + this.FGRUN);
                string = null;
                object = new ProgramRun(this.SYSTEM_ID, this.YKNO, this.LISTID, this.isDebug);
                bl = ((ProgramRun)object).execute();
                if (bl) {
                    string = FGRUN_2;
                }
                this.errMsg.append(((ProgramRun)object).getErrMsg()).append(CR);
            }
            if (bl && (this.FGRUN.equals(FGRUN_A) || this.FGRUN.equals(FGRUN_B) || this.FGRUN.equals(FGRUN_C) || this.FGRUN.equals(FGRUN_D))) {
                System.out.println("RUN_" + this.FGRUN);
                object = new RFIDPrintRequest(this.SYSTEM_ID, this.YKNO, this.LISTID, this.LANG, this.FGRUN, this.PRTID, this.PRGDIR, this.PRGFILE, this.OUT_DIR, null, this.isDebug);
                bl = ((RFIDPrintRequest)object).initialDataSet();
                if (bl) {
                    bl = ((RFIDPrintRequest)object).execute();
                }
                if (bl) {
                    string = ((RFIDPrintRequest)object).getFgkan();
                }
                this.errMsg.append(((RFIDPrintRequest)object).getErrMsg()).append(CR);
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ReportProcessing Execute Error! ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)runtimeException)).append(CR);
            bl = false;
        }
        return bl ? string : null;
    }

    public void clear() {
        this.SYSTEM_ID = null;
        this.YKNO = null;
        this.GROUPID = null;
        this.LISTID = null;
        this.JOKEN = null;
        this.OUT_DIR = null;
        this.OUT_FILE = null;
        this.outputFile = null;
        this.isDebug = false;
        this.FGRUN = null;
        this.PRTID = null;
        this.LANG = null;
        this.PRGDIR = null;
        this.PRGFILE = null;
        this.DMN_GRP = null;
        this.programFile = null;
        this.errMsg = new StringBuilder();
    }

    public void setSystemId(String string) {
        this.SYSTEM_ID = string;
    }

    public void setYkno(String string) {
        this.YKNO = string;
    }

    public void setGroupId(String string) {
        this.GROUPID = string;
    }

    public void setListId(String string) {
        this.LISTID = string;
    }

    public void setJoken(String string) {
        this.JOKEN = string;
    }

    public void setPrtId(String string) {
        this.PRTID = string;
    }

    public void setOutDir(String string) {
        this.OUT_DIR = string;
    }

    public void setOutFile(String string) {
        this.OUT_FILE = string;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    private boolean initialDataSet(ApplicationInfo applicationInfo) {
        String[] stringArray = new String[]{this.SYSTEM_ID, this.JOKEN};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE53_SELECT, (String[])stringArray, (ApplicationInfo)applicationInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE53 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("JOKEN=[").append(this.JOKEN).append(']');
            this.errMsg.append(CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][5])) continue;
            n = i;
            break;
        }
        if (this.PRTID == null) {
            this.PRTID = StringUtil.nval((String)stringArray2[n][1], (String)this.PRTID);
        }
        this.FGRUN = StringUtil.nval((String)stringArray2[n][0], (String)this.FGRUN);
        this.LANG = StringUtil.nval((String)stringArray2[n][2], (String)this.LANG);
        this.PRGDIR = StringUtil.nval((String)stringArray2[n][3], (String)this.PRGDIR);
        this.PRGFILE = StringUtil.nval((String)stringArray2[n][4], (String)this.PRGFILE);
        this.DMN_GRP = StringUtil.nval((String)stringArray2[n][6], (String)this.DMN_GRP);
        this.programFile = this.PRGDIR + HybsSystem.FS + this.PRGFILE;
        if (this.OUT_DIR != null && this.OUT_DIR.length() > 0 && this.OUT_FILE != null && this.OUT_FILE.length() > 0) {
            this.outputFile = this.OUT_DIR + HybsSystem.FS + this.OUT_FILE;
            File file = new File(this.OUT_DIR);
            if (!file.exists() && !file.mkdirs()) {
                String string = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.OUT_DIR + "]";
                throw new HybsSystemException(string);
            }
        }
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

