/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

public final class DBCellFactory {
    private static final String DEFAULT_RENDERER = "LABEL";
    private static final String DEFAULT_EDITOR = "TEXT";
    private static final Map<String, CellRenderer> rMap = new HashMap<String, CellRenderer>();
    private static final Map<String, CellEditor> eMap = new HashMap<String, CellEditor>();

    private DBCellFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CellRenderer newRenderer(String string, DBColumn dBColumn) {
        CellRenderer cellRenderer;
        String string2 = string == null ? DEFAULT_RENDERER : string.toUpperCase(Locale.JAPAN);
        String string3 = HybsSystem.sys("Renderer_" + string2);
        if (string3 == null) {
            String string4 = "Renderer \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=Renderer_" + string2 + " name=" + dBColumn.getName();
            throw new RuntimeException(string4);
        }
        Map<String, CellRenderer> map = rMap;
        synchronized (map) {
            cellRenderer = rMap.get(string2);
            if (cellRenderer == null) {
                cellRenderer = (CellRenderer)HybsSystem.newInstance(string3);
                rMap.put(string2, cellRenderer);
            }
        }
        return cellRenderer.newInstance(dBColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CellEditor newEditor(String string, DBColumn dBColumn) {
        CellEditor cellEditor;
        String string2 = string == null ? DEFAULT_EDITOR : string.toUpperCase(Locale.JAPAN);
        String string3 = HybsSystem.sys("Editor_" + string2);
        if (string3 == null) {
            String string4 = "Editor \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=Editor_" + string2 + " name=" + dBColumn.getName();
            throw new RuntimeException(string4);
        }
        Map<String, CellEditor> map = eMap;
        synchronized (map) {
            cellEditor = eMap.get(string2);
            if (cellEditor == null) {
                cellEditor = (CellEditor)HybsSystem.newInstance(string3);
                eMap.put(string2, cellEditor);
            }
        }
        return cellEditor.newInstance(dBColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Object> map = rMap;
        synchronized (map) {
            rMap.clear();
        }
        map = eMap;
        synchronized (map) {
            eMap.clear();
        }
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                DBCellFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

