/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_ImageTimeBar
extends ViewForm_HTMLTable {
    private static final String VERSION = "6.0.2.0 (2014/09/19)";
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color NULL_COLOR = Color.WHITE;
    private static final int MINUTE_OF_DAY = 1440;
    private static final long MILLI_MINUTE = 60000L;
    private static final String[] DAY_OF_WEEK_ja = new String[]{"\u571f", "\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
    private long startDate;
    private long timeSpan;
    private boolean useLegend;
    private int maxLabelWidth;
    private int maxTimeWidth;
    private int chartHeight;
    private int chartPadding;
    private int recodeMargin;
    private boolean useLastData;
    private String tempDir;
    private String tempUrl;
    private static final int keyClmNo = 0;
    private static final int dyClmNo = 1;
    private static final int fgjClmNo = 2;
    private int[] labelClmsNo = null;
    private int[] maxClmWidth = null;
    private int colClmNo = -1;
    private int tipsClmNo = -1;
    private int linkClmNo = -1;
    private int str2DateTime;
    private int startTime;
    private long nowTime;
    private int MAX_X;
    private int MAX_Y;
    private static final Stroke DSAH_STROK = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);

    @Override
    public String create(int n, int n2) {
        CharSequence charSequence;
        int n3;
        Object object;
        if (this.getRowCount() == 0) {
            return "";
        }
        this.paramInit();
        int n4 = this.getLastNo(n, n2);
        this.calcImageSize(n, n4);
        BufferedImage bufferedImage = new BufferedImage(this.MAX_X, this.MAX_Y, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(this.chartPadding, this.chartPadding, this.MAX_X - this.chartPadding * 2 + 1, this.MAX_Y - this.chartPadding * 2 + 1);
        StringBuilder stringBuilder = new StringBuilder(500);
        String string = "";
        long l = 0L;
        Color color = NULL_COLOR;
        FlgColorMap flgColorMap = new FlgColorMap();
        int n5 = this.useLegend ? 2 : 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.chartHeight + this.recodeMargin * 2;
        double d = (double)this.maxTimeWidth / (double)this.timeSpan;
        boolean bl = this.tipsClmNo >= 0 || this.linkClmNo >= 0;
        for (int i = n; i < n4; ++i) {
            long l2;
            String string2 = this.getValue(i, 0);
            object = this.getValue(i, 1);
            if (!string.equals(string2)) {
                if (i > n) {
                    l2 = this.nowTime;
                    if (l2 > this.timeSpan) {
                        l2 = this.timeSpan;
                    }
                    while (l < this.timeSpan) {
                        n6 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
                        n8 = (int)((double)(l2 - l) * d);
                        this.imageMeker(graphics2D, color, n6, n7, n8, bl, i, stringBuilder);
                        l = l2;
                        l2 = this.timeSpan;
                        color = NULL_COLOR;
                    }
                }
                string = string2;
                n7 = this.chartPadding + n9 * n5;
                ++n5;
                int n10 = this.labelClmsNo.length;
                n3 = this.chartPadding;
                int n11 = n7 + this.chartHeight + this.recodeMargin;
                graphics2D.setColor(LABEL_COLOR);
                for (int j = 0; j < n10; ++j) {
                    String string3 = this.getValueLabel(i, this.labelClmsNo[j]);
                    string3 = StringUtil.spanCut((String)string3);
                    graphics2D.drawString(string3, n3 + this.recodeMargin, n11);
                    n3 += this.recodeMargin * 2 + this.maxClmWidth[j];
                }
                graphics2D.drawRect(this.chartPadding, n7, this.MAX_X - this.chartPadding * 2, n9);
                l = 0L;
                color = NULL_COLOR;
            }
            if ((l2 = this.getStr2Date((String)object) - this.startDate) < l) {
                l2 = l;
            }
            n6 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            n8 = (int)((double)(l2 - l) * d);
            this.imageMeker(graphics2D, color, n6, n7, n8, bl, i, stringBuilder);
            l = l2;
            charSequence = this.getValue(i, 2);
            String string4 = this.getValueLabel(i, 2);
            color = this.colClmNo >= 0 ? flgColorMap.getColor((String)charSequence, string4, this.getValue(i, this.colClmNo)) : flgColorMap.getColor((String)charSequence, string4);
        }
        long l3 = this.nowTime;
        if (l3 > this.timeSpan) {
            l3 = this.timeSpan;
        }
        while (l < this.timeSpan) {
            n6 = this.chartPadding + this.maxLabelWidth + (int)((double)l * d);
            n8 = (int)((double)(l3 - l) * d);
            this.imageMeker(graphics2D, color, n6, n7, n8, bl, n4, stringBuilder);
            l = l3;
            l3 = this.timeSpan;
            color = NULL_COLOR;
        }
        this.imageHeaderPaint(graphics2D, d, flgColorMap);
        object = null;
        try {
            File file = new File(this.tempDir);
            if (!file.exists() && !file.mkdirs()) {
                String string5 = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5148\u306e\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002tempDir=[" + file + "]";
                throw new HybsSystemException(string5);
            }
            object = File.createTempFile("Img", ".png", file);
            ((File)object).deleteOnExit();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", (File)object);
            graphics2D.dispose();
        }
        catch (IOException iOException) {
            String string6 = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002tempDir=[" + this.tempDir + "]";
            throw new HybsSystemException(string6, (Throwable)iOException);
        }
        int n12 = this.MAX_X;
        n3 = this.MAX_Y;
        charSequence = new StringBuilder(500);
        ((StringBuilder)charSequence).append("<img id='ImageTimeBar' alt='ImageTimeBar' border='0'");
        ((StringBuilder)charSequence).append(" width='").append(n12).append("px' height='").append(n3).append("px'");
        ((StringBuilder)charSequence).append(" src='").append(this.tempUrl).append(((File)object).getName()).append("'");
        if (stringBuilder.length() > 0) {
            ((StringBuilder)charSequence).append(" usemap='#TimeBarMap' />");
            ((StringBuilder)charSequence).append("<map name='TimeBarMap'>");
            ((StringBuilder)charSequence).append((CharSequence)stringBuilder);
            ((StringBuilder)charSequence).append("</map>");
        } else {
            ((StringBuilder)charSequence).append(" />");
        }
        return ((StringBuilder)charSequence).toString();
    }

    private void imageMeker(Graphics2D graphics2D, Color color, int n, int n2, int n3, boolean bl, int n4, StringBuilder stringBuilder) {
        if (n3 > 0) {
            boolean bl2;
            if (this.useLastData) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(NULL_COLOR);
            }
            graphics2D.fillRect(n, n2 + this.recodeMargin, n3, this.chartHeight);
            boolean bl3 = bl2 = color != NULL_COLOR && this.useLastData && bl && n4 > 0;
            if (bl2) {
                String string;
                String string2;
                String string3 = string2 = this.tipsClmNo >= 0 ? this.getValueLabel(n4 - 1, this.tipsClmNo) : this.getValueLabel(n4 - 1, 2);
                if (string2 != null && string2.indexOf(39) >= 0) {
                    string2 = string2.replaceAll("'", "&#39;");
                }
                string2 = StringUtil.spanCut((String)string2);
                stringBuilder.append("<area shape='rect' alt='").append(string2).append("'");
                if (this.linkClmNo >= 0 && (string = this.getValueLabel(n4 - 1, this.linkClmNo)) != null && string.startsWith("href")) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(" coords='").append(n).append(',').append(n2 + this.recodeMargin).append(',');
                stringBuilder.append(n + n3).append(',').append(n2 + this.recodeMargin + this.chartHeight).append("' />");
            }
        }
    }

    private void paramInit() {
        String string = this.getParam("START_DATE");
        int n = this.getIntParam("TIME_SPAN");
        String[] stringArray = StringUtil.csv2Array((String)this.getParam("LABEL_CLMS"));
        String string2 = this.getParam("COLOR_CLM");
        String string3 = this.getParam("TIPS_CLM");
        String string4 = this.getParam("LINK_CLM");
        this.useLegend = this.getBoolParam("USE_LEGEND");
        this.maxLabelWidth = this.getIntParam("MAX_LABEL_WIDTH");
        this.maxTimeWidth = this.getIntParam("MAX_TIME_WIDTH");
        this.chartHeight = this.getIntParam("CHART_HEIGHT");
        this.chartPadding = this.getIntParam("CHART_PADDING");
        this.recodeMargin = this.getIntParam("RECODE_MARGIN");
        this.useLastData = this.getBoolParam("USE_LAST_DATA");
        this.tempDir = this.getParam("TEMP_DIR");
        this.tempUrl = this.getParam("TEMP_URL");
        this.startDate = this.getStr2Date(string);
        this.startTime = this.str2DateTime;
        this.timeSpan = (long)n * 60L;
        int n2 = stringArray.length;
        if (n2 > 0) {
            this.labelClmsNo = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.labelClmsNo[i] = this.getColumnNo(stringArray[i]);
            }
        } else {
            this.labelClmsNo = new int[]{0};
        }
        if (string2 != null) {
            this.colClmNo = this.getColumnNo(string2);
        }
        if (string3 != null) {
            this.tipsClmNo = this.getColumnNo(string3);
        }
        if (string4 != null) {
            this.linkClmNo = this.getColumnNo(string4);
        }
        Calendar calendar = Calendar.getInstance();
        this.nowTime = calendar.getTimeInMillis() / 60000L - this.startDate;
    }

    private void calcImageSize(int n, int n2) {
        int n3;
        String string = "";
        int n4 = this.labelClmsNo.length;
        this.maxClmWidth = new int[n4];
        int n5 = n3 = this.useLegend ? 2 : 1;
        if (this.maxLabelWidth < 0) {
            String string2;
            int n6;
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n6 = 0; n6 < n4; ++n6) {
                string2 = this.getColumnLabel(this.labelClmsNo[n6]);
                string2 = StringUtil.spanCut((String)string2);
                this.maxClmWidth[n6] = fontMetrics.stringWidth(string2);
            }
            for (n6 = n; n6 < n2; ++n6) {
                string2 = this.getValue(n6, 0);
                if (string.equals(string2)) continue;
                string = string2;
                ++n3;
                for (int i = 0; i < n4; ++i) {
                    String string3 = this.getValueLabel(n6, this.labelClmsNo[i]);
                    int n7 = fontMetrics.stringWidth(string3 = StringUtil.spanCut((String)string3));
                    if (this.maxClmWidth[i] >= n7) continue;
                    this.maxClmWidth[i] = n7;
                }
            }
            graphics2D.dispose();
            this.maxLabelWidth = this.recodeMargin * 2 * n4;
            for (n6 = 0; n6 < n4; ++n6) {
                this.maxLabelWidth += this.maxClmWidth[n6];
            }
        } else {
            int n8;
            for (n8 = n; n8 < n2; ++n8) {
                String string4 = this.getValue(n8, 0);
                if (string.equals(string4)) continue;
                string = string4;
                ++n3;
            }
            n8 = (this.maxLabelWidth - this.recodeMargin * 2 * n4) / n4;
            for (int i = 0; i < n4; ++i) {
                this.maxClmWidth[i] = n8;
            }
        }
        this.MAX_X = this.chartPadding * 2 + this.maxLabelWidth + this.maxTimeWidth;
        this.MAX_Y = this.chartPadding * 2 + (this.chartHeight + this.recodeMargin * 2) * n3;
    }

    private void imageHeaderPaint(Graphics2D graphics2D, double d, FlgColorMap flgColorMap) {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        int n4 = this.chartPadding;
        int n5 = this.chartPadding + this.chartHeight + this.recodeMargin;
        if (this.useLegend && flgColorMap != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n3 = fontMetrics.stringWidth(flgColorMap.getMaxLengthLabel());
            n2 = this.chartHeight;
            int n6 = this.recodeMargin;
            n = n3 + this.recodeMargin;
            int n7 = this.chartPadding;
            for (Object[] objectArray : flgColorMap.values()) {
                String string = (String)objectArray[0];
                serializable = (Color)objectArray[1];
                graphics2D.setColor((Color)serializable);
                graphics2D.fillRect(n7, n4 + this.recodeMargin, n2, this.chartHeight);
                graphics2D.setColor(LABEL_COLOR);
                graphics2D.drawString(string, n7 += n2 + n6, n5);
                n7 += n;
            }
            n4 += this.chartHeight + this.recodeMargin * 2;
            n5 += this.chartHeight + this.recodeMargin * 2;
        }
        graphics2D.setColor(LABEL_COLOR);
        graphics2D.drawRect(this.chartPadding, n4, this.MAX_X - this.chartPadding * 2, this.MAX_Y - n4 - this.chartPadding);
        int n8 = this.labelClmsNo.length;
        n3 = this.chartPadding;
        for (n2 = 0; n2 < n8; ++n2) {
            String string = this.getColumnLabel(this.labelClmsNo[n2]);
            string = StringUtil.spanCut((String)string);
            graphics2D.drawString(string, n3 + this.recodeMargin, n5);
            graphics2D.drawLine(n3 += this.recodeMargin * 2 + this.maxClmWidth[n2], n4, n3, this.MAX_Y - this.chartPadding);
        }
        n2 = TimeScaleStep.getStep(d);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.startDate * 60000L);
        n = calendar.get(7);
        String string = n2 < 1440 ? "yyyy/MM/dd(EE)" : "dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.JAPAN);
        graphics2D.setStroke(DSAH_STROK);
        n3 = this.chartPadding + this.maxLabelWidth;
        int n9 = 0;
        while ((long)n9 < this.timeSpan) {
            int n10 = this.chartHeight / 2 + this.recodeMargin;
            if (n9 % 1440 == 0) {
                serializable = new Date((this.startDate + (long)n9) * 60000L);
                graphics2D.drawString(simpleDateFormat.format((Date)serializable), n3 + this.recodeMargin, n5 - n10);
                n10 = 0;
            }
            graphics2D.drawString(this.getTime2Str(this.startTime + n9, n2, n), n3 + this.recodeMargin, n5);
            graphics2D.drawLine(n3, n4 + n10, n3, this.MAX_Y - this.chartPadding);
            n3 += (int)((double)n2 * d);
            n9 += n2;
        }
    }

    private long getStr2Date(String string) {
        Calendar calendar = Calendar.getInstance();
        this.str2DateTime = 0;
        if (string == null) {
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
        } else if (string.length() == 8) {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
        } else {
            calendar.clear();
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)));
            this.str2DateTime = Integer.parseInt(string.substring(8, 10)) * 60 + Integer.parseInt(string.substring(10, 12));
        }
        return calendar.getTimeInMillis() / 60000L;
    }

    private String getTime2Str(int n, int n2, int n3) {
        int n4 = n / 60 / 24;
        int n5 = n / 60 % 24;
        int n6 = n % 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 >= 1440) {
            stringBuilder.append(DAY_OF_WEEK_ja[(n4 + n3) % 7]);
        } else {
            if (n5 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n5);
            if (n2 < 60) {
                stringBuilder.append(':');
                if (n6 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n6);
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEditable() {
        return false;
    }

    private static final class FlgColorMap {
        private static final Color[] CLR_ARY = new Color[]{Color.BLUE, Color.CYAN, Color.GRAY, Color.GREEN, Color.LIGHT_GRAY, Color.MAGENTA, Color.DARK_GRAY, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
        private int lastCnt = 0;
        private final Map<String, Object[]> colMap = new TreeMap<String, Object[]>();
        private String maxLabel = "";
        private int maxlen = -1;

        private FlgColorMap() {
        }

        public Color getColor(String string, String string2) {
            return this.getColor(string, string2, null);
        }

        public Color getColor(String string, String string2, String string3) {
            Object[] objectArray;
            int n;
            if (string == null) {
                return LABEL_COLOR;
            }
            if (string2 != null && (n = string2.length()) > this.maxlen) {
                this.maxLabel = string2;
                this.maxlen = n;
            }
            if ((objectArray = this.colMap.get(string)) == null) {
                objectArray = new Object[]{string2, string3 != null ? ColorMap.getColorInstance((String)string3) : this.uniqColor()};
                this.colMap.put(string, objectArray);
            }
            return (Color)objectArray[1];
        }

        public Color uniqColor() {
            Color color = null;
            if (this.lastCnt < CLR_ARY.length) {
                color = CLR_ARY[this.lastCnt++];
            } else {
                Random random = new Random();
                int n = random.nextInt(256);
                int n2 = random.nextInt(256);
                int n3 = random.nextInt(256);
                color = new Color(n, n2, n3);
            }
            return color;
        }

        public Collection<Object[]> values() {
            return this.colMap.values();
        }

        public String getMaxLengthLabel() {
            return this.maxLabel;
        }
    }

    private static final class TimeScaleStep {
        private static final int[] STEPS = new int[]{10, 30, 60, 360, 720, 1440};
        private static final int MIN_PX = 25;

        private TimeScaleStep() {
        }

        public static int getStep(double d) {
            int n = (int)Math.ceil(25.0 / d);
            for (int i = 0; i < STEPS.length; ++i) {
                if (n > STEPS[i]) continue;
                return STEPS[i];
            }
            return (int)Math.ceil((double)n / (double)STEPS[STEPS.length - 1]) * STEPS[STEPS.length - 1];
        }
    }
}

