/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.daemon;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.transfer.TransferConfig;
import org.opengion.fukurou.transfer.TransferProcess;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class Daemon_Transfer
extends HybsTimerTask {
    private static final String VERSION = "5.5.5.1 (2012/08/07)";
    private static final String GE62_SELECT = "SELECT A.KBREAD,A.READOBJ,A.READPRM,A.KBEXEC,A.EXECDBID,A.EXECOBJ,A.EXECPRM,A.ERROR_SENDTO FROM GE62 A WHERE A.FGJ = '1'";
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool((String)"USE_DB_APPLICATION_INFO");
    private static final String HTTP_PROXY_HOST = HybsSystem.sys((String)"HTTP_PROXY_HOST");
    private static final int HTTP_PROXY_PORT = HybsSystem.sysInt((String)"HTTP_PROXY_PORT");
    private static final String HFROM = HybsSystem.sys((String)"TRANSFER_HOST_CODE");
    private static final int LOOP_COUNTER = 24;
    private boolean running = true;
    private int loopCnt = 0;
    private String ge62Select = null;
    private String dmnName = null;
    private ApplicationInfo appInfo = null;
    private boolean debug = false;
    protected final String DBID = HybsSystem.sys((String)"RESOURCE_DBID");

    public void initDaemon() {
        this.debug = StringUtil.nval((String)this.getValue("DEBUG"), (boolean)this.debug);
        this.dmnName = this.getName();
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(GE62_SELECT);
        String string = this.getValue("SYSTEM_ID");
        if (StringUtil.isNull((String)string)) {
            String string2 = "\u30b7\u30b9\u30c6\u30e0ID\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string2);
        }
        stringBuilder.append(" AND A.SYSTEM_ID='").append(string).append("'");
        String string3 = this.getValue("KBREAD");
        if (StringUtil.isNull((String)string3)) {
            String string4 = "\u8aad\u53d6\u65b9\u6cd5\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string4);
        }
        stringBuilder.append(" AND A.KBREAD='").append(string3).append("'");
        String string5 = this.getValue("DMN_GRP");
        if (StringUtil.isNull((String)string5)) {
            String string6 = "\u30c7\u30fc\u30e2\u30f3\u30b0\u30eb\u30fc\u30d7\u306f\u5fc5\u9808\u6307\u5b9a\u3067\u3059\u3002";
            throw new HybsSystemException(string6);
        }
        stringBuilder.append(" AND A.DMN_GRP='").append(string5).append("'");
        stringBuilder.append(" ORDER BY A.READOBJ,A.KBEXEC,A.EXECOBJ");
        this.ge62Select = stringBuilder.toString();
        if (this.debug) {
            System.out.println("DMN_NAME=[" + this.dmnName + "]");
            System.out.println("QUERY=[" + this.ge62Select + "]");
        }
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(string, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("TransferDaemon", this.dmnName, this.dmnName);
        } else {
            this.appInfo = null;
        }
    }

    protected void startDaemon() {
        Object object;
        if (this.loopCnt % 24 == 0) {
            this.loopCnt = 1;
            System.out.println();
            System.out.print(this.toString() + " " + new Date() + " ");
        } else {
            System.out.print(".");
            ++this.loopCnt;
        }
        GE62Data gE62Data = new GE62Data();
        try {
            String[][] stringArray = DBUtil.dbExecute((String)this.ge62Select, null, (ApplicationInfo)this.appInfo, (String)this.DBID);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; this.running && i < stringArray.length; ++i) {
                    gE62Data.addData((String[])stringArray[i]);
                }
            }
        }
        catch (Throwable throwable) {
            String string = "\u4f1d\u9001\u8aad\u53d6\u30a8\u30e9\u30fc\uff1aDMN_NAME=[" + this.dmnName + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "] , QUERY=[" + this.ge62Select + "]";
            object = string + HybsSystem.CR + StringUtil.stringStackTrace((Throwable)throwable);
            System.out.println((String)object);
            LogWriter.log((String)object);
            String string2 = HybsSystem.sys((String)"ERROR_MAIL_TO_USERS");
            this.sendMail(string, (String)object, string2);
        }
        for (String string : gE62Data.getTranSet()) {
            object = null;
            try {
                object = new TransferProcess(gE62Data.getConfSet(string));
                object.setDmnName(this.dmnName);
                object.setAppInfo(this.appInfo);
                if (this.debug) {
                    object.setDebug();
                }
                object.process();
            }
            catch (Throwable throwable) {
                Object object2;
                this.cancel();
                String string3 = "\u4f1d\u9001\u30a8\u30e9\u30fc\uff1aDMN_NAME=[" + this.dmnName + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "]";
                String string4 = null;
                if (object != null && (object2 = object.getLastConfig()) != null) {
                    string3 = string3 + " , CONFIG=[" + object2.toString() + "]";
                    string4 = object2.getErrorSendto();
                }
                object2 = string3 + HybsSystem.CR + StringUtil.stringStackTrace((Throwable)throwable);
                System.out.println((String)object2);
                LogWriter.log((String)object2);
                this.sendMail(string3, (String)object2, string4);
            }
        }
    }

    public boolean cancel() {
        this.running = false;
        return super.cancel();
    }

    protected void sendMail(String string, String string2, String string3) {
        String string4 = HybsSystem.sys((String)"COMMON_MAIL_SERVER");
        String string5 = HybsSystem.sys((String)"ERROR_MAIL_FROM_USER");
        Object[] objectArray = StringUtil.csv2Array((String)string3);
        if (string4 != null && string5 != null && objectArray.length > 0) {
            try {
                MailTX mailTX = new MailTX(string4);
                mailTX.setFrom(string5);
                mailTX.setTo((String[])objectArray);
                mailTX.setSubject(string);
                mailTX.setMessage(string2);
                mailTX.sendmail();
            }
            catch (Throwable throwable) {
                String string6 = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " SUBJECT:" + string + HybsSystem.CR + " HOST:" + string4 + HybsSystem.CR + " FROM:" + string5 + HybsSystem.CR + " TO:" + Arrays.toString(objectArray) + HybsSystem.CR + throwable.getMessage();
                LogWriter.log((String)string6);
                LogWriter.log((Throwable)throwable);
            }
        }
    }

    private static class GE62Data {
        private final Set<String> tranSet = new LinkedHashSet<String>();
        private final Map<String, Set<TransferConfig>> tran2ConfSet = new LinkedHashMap<String, Set<TransferConfig>>();

        private GE62Data() {
        }

        private void addData(String[] stringArray) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            String string6 = stringArray[5];
            String string7 = stringArray[6];
            String string8 = stringArray[7];
            String string9 = string2;
            this.tranSet.add(string9);
            Set<TransferConfig> set = this.tran2ConfSet.get(string9);
            if (set == null) {
                set = new LinkedHashSet<TransferConfig>();
            }
            TransferConfig transferConfig = new TransferConfig(string, string2, string3, string4, string5, string6, string7, string8, HFROM, HTTP_PROXY_HOST, HTTP_PROXY_PORT);
            set.add(transferConfig);
            this.tran2ConfSet.put(string9, set);
        }

        private Set<String> getTranSet() {
            return this.tranSet;
        }

        private Set<TransferConfig> getConfSet(String string) {
            return this.tran2ConfSet.get(string);
        }
    }
}

