/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.text.BreakIterator;
import org.firebirdsql.jdbc.FBEscapedCallParser;
import org.firebirdsql.jdbc.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedParser {
    public static final int USE_BUILT_IN = 0;
    public static final int USE_STANDARD_UDF = 1;
    protected static final int UNDEFINED_STATE = 0;
    protected static final int NORMAL_STATE = 1;
    protected static final int LITERAL_STATE = 2;
    protected static final int ESCAPE_STATE = 4;
    public static final String ESCAPE_CALL_KEYWORD = "call";
    public static final String ESCAPE_CALL_KEYWORD3 = "?";
    public static final String ESCAPE_DATE_KEYWORD = "d";
    public static final String ESCAPE_TIME_KEYWORD = "t";
    public static final String ESCAPE_TIMESTAMP_KEYWORD = "ts";
    public static final String ESCAPE_FUNCTION_KEYWORD = "fn";
    public static final String ESCAPE_ESCAPE_KEYWORD = "escape";
    public static final String ESCAPE_OUTERJOIN_KEYWORS = "oj";
    protected static final String CHECK_CALL_1 = "{call";
    protected static final String CHECK_CALL_2 = "{?";
    protected static final String CHECK_DATE = "{d";
    protected static final String CHECK_TIME = "{t";
    protected static final String CHECK_TIMESTAMP = "{ts";
    protected static final String CHECK_FUNCTION = "{fn";
    protected static final String CHECK_ESCAPE = "{escape";
    protected static final String CHECK_OUTERJOIN = "{oj";
    private int state = 1;
    private int lastState = 1;
    private int nestedEscaped = 0;
    private int mode;

    public FBEscapedParser(int mode) {
        this.mode = mode;
    }

    protected int getLastState() {
        return this.lastState;
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) throws IllegalStateException {
        int tempState = this.getLastState();
        this.lastState = this.getState();
        if (state == 1) {
            this.state = 1;
        } else if (state == 2) {
            this.state = 2;
        } else if (state == 4) {
            this.state = 4;
        } else {
            this.lastState = tempState;
            throw new IllegalStateException("State " + state + " is unknown.");
        }
    }

    protected boolean isInState(int state) {
        return this.getState() == state;
    }

    protected boolean wasInState(int state) {
        return this.getLastState() == state;
    }

    protected void switchState(char testChar) {
        switch (testChar) {
            case '\'': {
                if (this.isInState(1)) {
                    this.setState(2);
                    break;
                }
                if (!this.isInState(2)) break;
                this.setState(1);
                break;
            }
            case '{': {
                if (this.isInState(1)) {
                    this.setState(4);
                }
                ++this.nestedEscaped;
                break;
            }
            case '}': {
                if (this.isInState(4)) {
                    --this.nestedEscaped;
                }
                if (this.nestedEscaped != 0) break;
                this.setState(1);
            }
        }
    }

    protected boolean checkForEscapes(String sql) {
        return (sql = sql.toLowerCase()).indexOf(CHECK_CALL_1) != -1 || sql.indexOf(CHECK_CALL_2) != -1 || sql.indexOf(CHECK_DATE) != -1 || sql.indexOf(CHECK_ESCAPE) != -1 || sql.indexOf(CHECK_FUNCTION) != -1 || sql.indexOf(CHECK_OUTERJOIN) != -1 || sql.indexOf(CHECK_TIME) != -1 || sql.indexOf(CHECK_TIMESTAMP) != -1;
    }

    public String parse(String sql) throws FBSQLException {
        this.lastState = 1;
        this.state = 1;
        this.nestedEscaped = 0;
        if (!this.checkForEscapes(sql)) {
            return sql;
        }
        char[] sqlbuff = sql.toCharArray();
        StringBuffer buffer = new StringBuffer();
        StringBuffer escape = new StringBuffer();
        for (int i = 0; i < sqlbuff.length; ++i) {
            this.switchState(sqlbuff[i]);
            if (this.isInState(1) && (this.wasInState(1) || this.wasInState(2))) {
                buffer.append(sqlbuff[i]);
                continue;
            }
            if (this.isInState(1) && this.wasInState(4)) {
                buffer.append(this.escapeToNative(escape.substring(1, escape.length())));
                escape = new StringBuffer();
                this.setState(1);
                continue;
            }
            if (this.isInState(4)) {
                escape.append(sqlbuff[i]);
                continue;
            }
            if (!this.isInState(2)) continue;
            buffer.append(sqlbuff[i]);
        }
        return buffer.toString();
    }

    protected void processEscaped(String escaped, StringBuffer keyword, StringBuffer payload) {
        if (keyword.length() != 0) {
            keyword.delete(0, keyword.length());
        }
        if (payload.length() != 0) {
            payload.delete(0, payload.length());
        }
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(escaped);
        int keyStart = iterator.first();
        int keyEnd = iterator.next();
        keyword.append(escaped.substring(keyStart, keyEnd));
        payload.append(escaped.substring(keyEnd, escaped.length()));
    }

    protected String escapeToNative(String escaped) throws FBSQLException {
        StringBuffer keyword = new StringBuffer();
        StringBuffer payload = new StringBuffer();
        this.processEscaped(escaped, keyword, payload);
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD)) {
            StringBuffer call = new StringBuffer();
            call.append('{').append(keyword).append(' ').append(payload).append('}');
            return this.convertProcedureCall(call.toString());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_CALL_KEYWORD3)) {
            StringBuffer call = new StringBuffer();
            call.append('{').append(ESCAPE_CALL_KEYWORD3).append(payload).append('}');
            return this.convertProcedureCall(call.toString());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_DATE_KEYWORD)) {
            return this.toDateString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_ESCAPE_KEYWORD)) {
            return this.convertEscapeString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_FUNCTION_KEYWORD)) {
            return this.convertEscapedFunction(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_OUTERJOIN_KEYWORS)) {
            return this.convertOuterJoin(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIME_KEYWORD)) {
            return this.toTimeString(payload.toString().trim());
        }
        if (keyword.toString().equalsIgnoreCase(ESCAPE_TIMESTAMP_KEYWORD)) {
            return this.toTimestampString(payload.toString().trim());
        }
        throw new FBSQLParseException("Unknown keyword " + keyword + " for escaped syntax.");
    }

    protected String toDateString(String dateStr) throws FBSQLParseException {
        return dateStr;
    }

    protected String toTimeString(String timeStr) throws FBSQLParseException {
        return timeStr;
    }

    protected String toTimestampString(String timestampStr) throws FBSQLParseException {
        return timestampStr;
    }

    protected String convertProcedureCall(String procedureCall) throws FBSQLException {
        FBEscapedCallParser tempParser = new FBEscapedCallParser(this.mode);
        FBProcedureCall call = tempParser.parseCall(procedureCall);
        return call.getSQL(false);
    }

    protected String convertOuterJoin(String outerJoin) throws FBSQLParseException {
        return outerJoin;
    }

    protected String convertEscapeString(String escapeString) {
        return "ESCAPE " + escapeString;
    }

    protected String convertEscapedFunction(String escapedFunction) throws FBSQLParseException {
        String templateResult = FBEscapedFunctionHelper.convertTemplate(escapedFunction, this.mode);
        if (templateResult != null) {
            return templateResult;
        }
        return escapedFunction;
    }

    public static boolean supportsStoredProcedures() {
        return true;
    }

    public static boolean supportsLikeEscapeClause() {
        return false;
    }
}

