/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;

public class FBXAConnectionHandle
implements InvocationHandler {
    private static final Method CONNECTION_CLOSE = ReflectionHelper.findMethod(Connection.class, "close", new Class[0]);
    private static final Method CONNECTION_IS_CLOSED = ReflectionHelper.findMethod(Connection.class, "isClosed", new Class[0]);
    private AbstractConnection connection;
    private XAConnection owner;
    private Connection proxy;
    private SQLException closeStackTrace;

    public FBXAConnectionHandle(AbstractConnection connection, XAConnection owner) throws SQLException {
        this.connection = connection;
        this.owner = owner;
        Class[] implementedInterfaces = ReflectionHelper.getAllInterfaces(connection.getClass());
        this.proxy = (Connection)Proxy.newProxyInstance(FirebirdConnection.class.getClassLoader(), implementedInterfaces, (InvocationHandler)this);
    }

    public Connection getProxy() {
        return this.proxy;
    }

    public XAConnection getXAConnection() {
        return this.owner;
    }

    public void handleConnectionClose() throws SQLException {
        this.connection = null;
        this.closeStackTrace = new SQLException("Close trace.");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.connection == null) {
                if (CONNECTION_IS_CLOSED.equals(method)) {
                    return Boolean.TRUE;
                }
                FBSQLException ex = new FBSQLException("Connection " + this + " was closed. " + "See the attached exception to find the place " + "where it was closed");
                ex.setNextException(this.closeStackTrace);
                throw ex;
            }
            if (method.equals(CONNECTION_CLOSE)) {
                this.handleConnectionClose();
                return Void.TYPE;
            }
            return method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (SQLException ex) {
            throw ex;
        }
    }
}

