/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.util.LittleEndian;

public final class LineSpacingDescriptor
implements Cloneable {
    short _dyaLine;
    short _fMultiLinespace;

    public LineSpacingDescriptor() {
        this._dyaLine = (short)240;
        this._fMultiLinespace = 1;
    }

    public LineSpacingDescriptor(byte[] buf, int offset) {
        this._dyaLine = LittleEndian.getShort((byte[])buf, (int)offset);
        this._fMultiLinespace = LittleEndian.getShort((byte[])buf, (int)(offset + 2));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setMultiLinespace(short fMultiLinespace) {
        this._fMultiLinespace = fMultiLinespace;
    }

    public int toInt() {
        byte[] intHolder = new byte[4];
        this.serialize(intHolder, 0);
        return LittleEndian.getInt((byte[])intHolder);
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this._dyaLine);
        LittleEndian.putShort((byte[])buf, (int)(offset + 2), (short)this._fMultiLinespace);
    }

    public void setDyaLine(short dyaLine) {
        this._dyaLine = dyaLine;
    }

    public boolean equals(Object o) {
        LineSpacingDescriptor lspd = (LineSpacingDescriptor)o;
        return this._dyaLine == lspd._dyaLine && this._fMultiLinespace == lspd._fMultiLinespace;
    }

    public boolean isEmpty() {
        return this._dyaLine == 0 && this._fMultiLinespace == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[LSPD] EMPTY";
        }
        return "[LSPD] (dyaLine: " + this._dyaLine + "; fMultLinespace: " + this._fMultiLinespace + ")";
    }
}

