/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.StyleName;
import org.odftoolkit.odfdom.type.StyleNameRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleNameRefs
implements OdfDataType {
    private String mStyleNames;

    public StyleNameRefs(List<StyleName> styleNames) throws IllegalArgumentException {
        if (styleNames == null) {
            throw new IllegalArgumentException("parameter can not be null for StyleNameRefs");
        }
        StringBuffer aRet = new StringBuffer();
        Iterator<StyleName> aIter = styleNames.iterator();
        while (aIter.hasNext()) {
            if (aRet.length() > 0) {
                aRet.append(' ');
            }
            String aStyleName = aIter.next().toString();
            aRet.append(aStyleName);
        }
        this.mStyleNames = aRet.toString();
    }

    public String toString() {
        return this.mStyleNames;
    }

    public static StyleNameRefs valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null) {
            throw new IllegalArgumentException("parameter is invalidate for datatype StyleNameRefs");
        }
        ArrayList<StyleName> aRet = new ArrayList<StyleName>();
        if (stringValue.length() > 0) {
            String[] names = stringValue.split(" ");
            for (int i = 0; i < names.length; ++i) {
                aRet.add(new StyleName(names[i]));
            }
        }
        return new StyleNameRefs(aRet);
    }

    public List<StyleName> getStyleNameRefList() {
        ArrayList<StyleName> aRet = new ArrayList<StyleName>();
        if (this.mStyleNames.length() > 0) {
            String[] names = this.mStyleNames.split(" ");
            for (int i = 0; i < names.length; ++i) {
                aRet.add(new StyleName(names[i]));
            }
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return true;
        }
        String[] names = stringValue.split(" ");
        for (int i = 0; i < names.length; ++i) {
            if (StyleNameRef.isValid(names[i])) continue;
            return false;
        }
        return true;
    }
}

