<jsp:directive.page pageEncoding="UTF-8" />
<og:value key="SQL" xssCheck="false">{@INSQL}</og:value>

<og:equals val1="{@TABLE}{@CLM}" val2="{@TABLE}{@CLM}" >
	<!-- ORACLE  -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
		<og:value key="SQL" >
			select OWNER,TABLE_NAME,COLUMN_ID AS SEQNO,COLUMN_NAME,'' AS DBLABEL,DATA_TYPE,
				    (CASE WHEN DATA_PRECISION IS NULL THEN DATA_LENGTH ELSE (DATA_PRECISION+0.1*DATA_SCALE) END) AS DATA_LENGTH,
					DECODE(NULLABLE,'N','NN','') AS NN,DATA_DEFAULT
			from DBA_TAB_COLS
			<og:where>
				<og:and value="OWNER		=	 '{@OWNER}'"	/>
				<og:and value="TABLE_NAME  like '{@TABLE}%'"	/>
				<og:and value="COLUMN_NAME like '{@CLM}%'"		/>
				<og:and value="INSTR(TABLE_NAME,'$') < 1"		/>
			</og:where>
			order by OWNER,TABLE_NAME,SEQNO
		</og:value>
	</og:equals>

	<!-- FIREBIRD  -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
		<og:value key="SQL" >
			select
				trim(r.RDB$RELATION_NAME)	AS TABLE_NAME,
				r.RDB$FIELD_POSITION		AS SEQNO,
				trim(r.RDB$FIELD_NAME)		AS COLUMN_NAME,
				''							AS DBLABEL,
				CASE f.RDB$FIELD_TYPE
					WHEN   7 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'SMALLINT'
						END
					WHEN   8 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INTEGER'
						END
					WHEN  16 THEN
						CASE f.RDB$FIELD_SUB_TYPE
							WHEN 1 THEN 'NUMERIC'
							WHEN 2 THEN 'DECIMAL'
							ELSE        'INT64'
						END
					WHEN   9 THEN 'QUAD'
					WHEN  10 THEN 'FLOAT'
					WHEN  11 THEN 'D_FLOAT'
					WHEN  12 THEN 'DATE'
					WHEN  13 THEN 'TIME'
					WHEN  14 THEN 'CHAR'
					WHEN  27 THEN 'DOUBLE'
					WHEN  35 THEN 'TIMESTAMP'
					WHEN  37 THEN 'VARCHAR'
					WHEN  40 THEN 'CSTRING'
					WHEN 261 THEN 'BLOB'
					ELSE 'UNKNOWN'
					END AS DATA_TYPE ,
		--		f.RDB$FIELD_LENGTH			AS DATA_LENGTH ,
				f.RDB$CHARACTER_LENGTH 		AS DATA_LENGTH ,
				( CASE WHEN r.RDB$NULL_FLAG = '1' THEN 'NN' ELSE '' END ) AS NN,
				replace(upper(r.RDB$DEFAULT_SOURCE),'DEFAULT ','') AS DATA_DEFAULT
			from RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f
			ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
			where r.RDB$SYSTEM_FLAG = 0
			<og:where startKey="and">
				<og:and value = "r.RDB$RELATION_NAME like '{@TABLE}%'"	/>
				<og:and value = "r.RDB$FIELD_NAME    like '{@CLM}%'"	/>
			</og:where>
			order by r.RDB$RELATION_NAME,r.RDB$FIELD_POSITION
		</og:value>
	</og:equals>
</og:equals>

<og:equals val1="{@INDEX}" val2="{@INDEX}" >
	<!-- ORACLE  -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
		<og:value key="SQL" >
			select INDEX_OWNER,TABLE_NAME,INDEX_NAME,COLUMN_POSITION AS SEQNO,COLUMN_NAME,COLUMN_NAME AS DBLABEL,DESCEND
			from DBA_IND_COLUMNS
			<og:where>
				<og:and value="INDEX_OWNER	=	 '{@OWNER}'"	/>
				<og:and value="TABLE_NAME  like '{@TABLE}%'"	/>
				<og:and value="INDEX_NAME  like '{@INDEX}%'"	/>
				<og:and value="COLUMN_NAME like '{@CLM}%'"		/>
				<og:and value="INSTR(TABLE_NAME,'$') < 1" />
				<og:and value="INSTR(COLUMN_NAME,'$') < 1" />
			</og:where>
			order by INDEX_OWNER,TABLE_NAME,INDEX_NAME,SEQNO
		</og:value>
	</og:equals>

	<!-- FIREBIRD  -->
	<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
		<og:value key="SQL" >
			select  trim(a.RDB$RELATION_NAME)	AS TABLE_NAME, 
					trim(a.RDB$INDEX_NAME)		AS INDEX_NAME, 
					b.RDB$FIELD_POSITION+1		AS SEQNO, 
					trim(b.RDB$FIELD_NAME)		AS COLUMN_NAME, 
					trim(b.RDB$FIELD_NAME)		AS DBLABEL, 
					trim(a.RDB$DESCRIPTION		AS DESCEND
			from RDB$INDICES a inner join RDB$INDEX_SEGMENTS b
			on   a.RDB$INDEX_NAME = b.RDB$INDEX_NAME
			where a.RDB$SYSTEM_FLAG = 0
			<og:where startKey="and">
				<og:and value = "a.RDB$RELATION_NAME like '{@TABLE}%'"	/>
				<og:and value = "a.RDB$INDEX_NAME    like '{@INDEX}%'"	/>
				<og:and value = "b.RDB$FIELD_NAME    like '{@CLM}%'"	/>
			</og:where>
			order by a.RDB$RELATION_NAME,a.RDB$INDEX_NAME,b.RDB$FIELD_POSITION
		</og:value>
	</og:equals>
</og:equals>

<og:equals val1="{@OBJECT_TYPE}" val2="{@OBJECT_TYPE}" >
	<!-- ORACLE  -->
		<og:value key="SQL" >
			select OWNER,OBJECT_TYPE,OBJECT_NAME,OBJECT_NAME AS DBLABEL,STATUS AS STTS,
				'' AS DEL,'' AS COMPILE,CREATED,LAST_DDL_TIME,TIMESTAMP
			from ALL_OBJECTS
			<og:where>
				<og:and value="OWNER		=    '{@OWNER}'"		/>
				<og:and value="OBJECT_NAME like '{@OBJECT_NAME}%'"	/>
				<og:and value="OBJECT_NAME not like 'DBA_%'"		/>
				<og:and value="OBJECT_TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="STATUS		=	 '{@STATUS}'"		/>
				<og:and value="INSTR(OBJECT_NAME,'$') < 1" />
			</og:where>
			<og:appear startKey="order by" value="{@ORDER_BY}"
						defaultVal="OWNER,OBJECT_NAME,OBJECT_TYPE" />
		</og:value>

	<og:viewLink command="{@command}">
		<og:link column="OBJECT_NAME" href="viewObject.jsp" target="SUB_WIND"
			keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
		<og:link column="STTS" href="viewObject.jsp" target="SUB_WIND" onLink="INVALID" markList="[STTS]"
			keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],ERRORS,[OBJECT_NAME],{@DBID}" />
		<og:link column="DEL" href="drop.jsp" target="SUB_WIND" onClick="return confirm('DROP [OBJECT_TYPE] [OBJECT_NAME]');"
			lbl="MSG0058"
			keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
		<og:link column="COMPILE" href="compile.jsp" target="SUB_WIND" lbl="SUBMIT"
			keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="SHOW_ERROR" >
	<og:value key="SQL" >
		select OWNER,NAME,TYPE,LINE,POSITION,TEXT
		from DBA_ERRORS
		<og:where>
			<og:and value="OWNER	=	 '{@OWNER}'"		/>
			<og:and value="NAME	 like '{@OBJECT_NAME}%'"	/>
			<og:and value="TEXT not like 'PL/SQL%ignored%'"	/>
		</og:where>
		order by OWNER,NAME,LINE,POSITION
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[LINE],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED" contains="true">
	<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED">
		<og:value key="SQL" >
			select OWNER,NAME,TYPE
					,REFERENCED_OWNER as REF_OWNER
					,REFERENCED_NAME  as REF_NAME
					,REFERENCED_TYPE  as REF_TYPE
					,'' DEL
			from dba_dependencies
			<og:where>
				<og:and value="OWNER	=	 '{@OWNER}'"		/>
				<og:and value="NAME    like '{@OBJECT_NAME}%'"	/>
				<og:and value="REFERENCED_NAME like '{@REF_NAME}%'"	/>
				<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
							 and exists ( select 'X' from DBA_ERRORS B
									where dba_dependencies.OWNER = B.OWNER
									and   dba_dependencies.NAME  = B.NAME
									and   dba_dependencies.TYPE  = B.TYPE )"	/>
				<og:and value="INSTR(NAME,'$') < 1" />
			</og:where>
			order by OWNER,NAME,TYPE,REF_TYPE,REF_NAME
		</og:value>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED_RECDOWN">
		<!-- OWNER,OBJECT_NAME ́AK{ɂȂ -->
		<og:columnCheck nullCheck="OWNER,OBJECT_NAME" />
		<og:value key="SQL">
			select LEVEL,OWNER,NAME,TYPE
					,REFERENCED_OWNER as REF_OWNER
					,REFERENCED_NAME  as REF_NAME
					,REFERENCED_TYPE  as REF_TYPE
					,'' DEL
			from dba_dependencies
			<og:where>
				<og:and value="OWNER	=	 '{@OWNER}'"		/>
				<og:and value="REFERENCED_NAME like '{@REF_NAME}%'"	/>
				<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
							 and exists ( select 'X' from DBA_ERRORS B
									where dba_dependencies.OWNER = B.OWNER
									and   dba_dependencies.NAME  = B.NAME
									and   dba_dependencies.TYPE  = B.TYPE )"	/>
				<og:and value="INSTR(NAME,'$') < 1" />
			</og:where>
			start with OWNER = '{@OWNER}'
			and NAME = '{@OBJECT_NAME}'
			connect by prior REFERENCED_NAME = NAME
			and prior REFERENCED_TYPE = TYPE
			and prior OWNER = OWNER
			and REFERENCED_NAME != NAME
		</og:value>
	</og:equals>

	<og:equals val1="{@EXEC_TYPE}" val2="REFERENCED_RECUP">
		<!-- OWNER,REF_NAME ́AK{ɂȂ -->
		<og:columnCheck nullCheck="OWNER,REF_NAME" />
		<og:value key="SQL">
			select LEVEL,OWNER,NAME,TYPE
					,REFERENCED_OWNER as REF_OWNER
					,REFERENCED_NAME  as REF_NAME
					,REFERENCED_TYPE  as REF_TYPE
					,'' DEL
			from dba_dependencies
			<og:where>
				<og:and value="OWNER	=	 '{@OWNER}'"		/>
				<og:and value="NAME like '{@OBJECT_NAME}%'"	/>
				<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
				<og:and value="REFERENCED_TYPE = '{@REF_TYPE}'
							 and exists ( select 'X' from DBA_ERRORS B
									where dba_dependencies.OWNER = B.OWNER
									and   dba_dependencies.NAME  = B.NAME
									and   dba_dependencies.TYPE  = B.TYPE )"	/>
				<og:and value="INSTR(NAME,'$') < 1" />
			</og:where>
			start with OWNER = '{@OWNER}'
			and REFERENCED_NAME = '{@REF_NAME}'
			connect by prior NAME = REFERENCED_NAME
			and prior TYPE = REFERENCED_TYPE
			and prior OWNER = OWNER
			and REFERENCED_NAME != NAME
		</og:value>
	</og:equals>

	<og:viewLink command="{@command}">
		<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,REF_NAME,DBID" vals="NEW,[OWNER],[TYPE],[NAME],[REF_NAME],{@DBID}" />
		<og:link column="REF_NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,REF_NAME,DBID" vals="NEW,[REF_OWNER],[REF_TYPE],[REF_NAME],,{@DBID}" />
		<og:link column="DEL" href="drop.jsp" target="SUB_WIND" onClick="return confirm('DROP [TYPE] [NAME]');"
			lbl="MSG0058"
			keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[TYPE],[NAME],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@SEL_TYPE}" val2="ERRCODE" >
	<og:value key="SQL" >
		select ERR_CODE( '{@OBJECT_NAME}' ) from DUAL
	</og:value>
</og:equals>

<og:equals val1="{@SEL_TYPE}" val2="KILL" >
	<og:value key="SQL" >
		SELECT '' as DEL,SID,SERIAL# AS SERIAL,
		SCHEMANAME as SCHEMA,OSUSER,MACHINE,MODULE,ACTION,CLIENT_INFO,TYPE,PROGRAM,LOGON_TIME,STATUS
		FROM V$SESSION
		<og:where>
			<og:and value="SCHEMANAME	= '{@OWNER}'"	/>
		</og:where>
		order by SID,SERIAL#
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="DEL" href="sessionKill.jsp" target="SUB_WIND"
			keys="command,SID,SERIAL,DBID" vals="NEW,[SID],[SERIAL],{@DBID}" lbl="MSG0058" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@SEL_TYPE}" val2="LOCK" >
	<og:value command="SQL">
		SELECT B.SID, B.ID1, C.OBJECT_NAME 
		FROM V$LOCK B, USER_OBJECTS C 
		WHERE C.OBJECT_ID = B.ID1
		AND   ROWNUM = 1
	</og:value>

	<og:value key="SQL" >
		SELECT '' as DEL,'{@OBJECT_NAME}' AS OBJECT_NAME,SID,SERIAL# AS SERIAL,
		SCHEMANAME as SCHEMA,OSUSER,MACHINE,MODULE,ACTION,CLIENT_INFO,TYPE,PROGRAM,LOGON_TIME,STATUS
		FROM V$SESSION
		WHERE SID = '{@SID}'
		<og:where startKey="and">
			<og:and value="SCHEMANAME	= '{@OWNER}'"	/>
		</og:where>
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="DEL" href="sessionKill.jsp" target="SUB_WIND"
			keys="command,SID,SERIAL,DBID" vals="NEW,[SID],[SERIAL],{@DBID}" lbl="MSG0058" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@SEL_TYPE}" val2="CONSTRAINT" >
	<og:value key="SQL" >
		SELECT '' as DEL,OWNER,CONSTRAINT_NAME,CONSTRAINT_TYPE,
				TABLE_NAME,INDEX_NAME,INDEX_OWNER,STATUS,LAST_CHANGE
		FROM USER_CONSTRAINTS
		WHERE CONSTRAINT_NAME not like 'SYS_%'
		AND   CONSTRAINT_NAME not like 'BIN$%'
		<og:where startKey="and">
			<og:and value="OWNER			=	 '{@OWNER}'"		/>
			<og:and value="CONSTRAINT_NAME	like '{@OBJECT_NAME}%'"	/>
		</og:where>
		order by OWNER,CONSTRAINT_NAME,CONSTRAINT_TYPE,TABLE_NAME
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="DEL" href="constraintDrop.jsp" target="SUB_WIND"
			keys="command,CONSTRAINT_NAME,TABLE_NAME,DBID" vals="NEW,[CONSTRAINT_NAME],[TABLE_NAME],{@DBID}" lbl="MSG0058" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="EXEC_PLAN" >
	<og:forward page="explainPlan.jsp" keys="command" vals="NEW" />
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="ALL_COMPILE" >
	<og:forward page="allCompile.jsp" keys="command" vals="NEW" />
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="TABLESPACE" >
	<og:forward page="tableSpace.jsp" keys="command" vals="NEW" />
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="SEQUENCE" >
	<og:value key="SQL">
		select SEQUENCE_OWNER AS OWNER,
				SEQUENCE_NAME AS NAME,
				'CREATE SEQUENCE ' || SEQUENCE_NAME ||
				' INCREMENT BY ' || INCREMENT_BY ||
				' START WITH ' || LAST_NUMBER ||
				' MAXVALUE ' || MAX_VALUE ||
				' CYCLE NOCACHE;' as QUERY
		from DBA_SEQUENCES
		<og:where>
			<og:and value="SEQUENCE_OWNER = '{@OWNER}'" />
			<og:and value="SEQUENCE_NAME like '{@OBJECT_NAME}'"	/>
		</og:where>
		order by SEQUENCE_OWNER,SEQUENCE_NAME
	</og:value>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="GREP_SRC" >
	<og:value key="SQL">
		select TYPE,NAME,LINE,TEXT,OWNER
		from DBA_SOURCE
		where   OWNER = '{@OWNER}'
		<og:where startKey="AND">
			<og:and value="NAME like '{@NAME}'"		/>
			<og:and value="TYPE in ( {@OBJECT_TYPE} )" multi="true" />
			<og:and value="TEXT like '%{@REF_NAME}%'"	/>
		</og:where>
		order by TYPE,NAME,LINE
	</og:value>

	<og:viewLink command="{@command}">
		<og:link column="NAME" href="viewObject.jsp" target="SUB_WIND" 
			keys="command,OWNER,TYPE,NAME,LINE,DBID" vals="NEW,{@OWNER},[TYPE],[NAME],[LINE],{@DBID}" />
	</og:viewLink>
</og:equals>

<og:equals val1="{@EXEC_TYPE}" val2="FILE_SAVE" >
	<og:forward page="fileSave.jsp" keys="command" vals="NEW" />
</og:equals>
