/****************************************************************************/
/* GF46 ( 位置情報サンプル )                                                */
/*                                                                          */
/* Created : 2013/07/17 17:13:48                                            */
/****************************************************************************/
CREATE TABLE GF46 (
   LOC_ID       VARCHAR ( 100 )                 NOT NULL            /*   0 位置ID       */
 , ROW_ID       INTEGER                         NOT NULL            /*   1 行ID         */
 , COL_ID       INTEGER                         NOT NULL            /*   1 列ID         */
 , FGCELLEDIT   VARCHAR (   1 )                                     /*   3 枡編集F      */
 , CELLNAME     VARCHAR ( 100 )                                     /*   4 枡名         */
 , VALUE        VARCHAR ( 100 )                                     /*   5 値           */
 , COLOR        VARCHAR (  50 )                                     /*   6 色           */
 , CDJ          VARCHAR (   2 )                 NOT NULL            /*   7 状況C        */
 , UNIQ         BIGINT                          NOT NULL            /* 800 ユニークキー */
 , FGJ          VARCHAR (   1 )     DEFAULT '1' NOT NULL            /* 810 状態フラグ   */
 , DYSET        VARCHAR (  14 )                                     /* 820 登録日時     */
 , PGSET        VARCHAR (  10 )                                     /* 830 作成PG       */
 , PGPSET       VARCHAR (  10 )                                     /* 840 作成親PG     */
 , USRSET       VARCHAR (  10 )                                     /* 850 作成社員     */
 , DYUPD        VARCHAR (  14 )                                     /* 860 更新日時     */
 , PGUPD        VARCHAR (  10 )                                     /* 870 更新PG       */
 , PGPUPD       VARCHAR (  10 )                                     /* 880 更新親PG     */
 , USRUPD       VARCHAR (  10 )                                     /* 890 更新者       */
);

CREATE SEQUENCE GF46S00 ;


CREATE TRIGGER GF46T00 FOR GF46
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF46S00,1 );
  END; 


