<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLENAME AS TABLE_NAME ,TABLENAME AS NAME_JA,
				0 AS JKENSU,1000 AS SKENSU,TABLESPACE AS TABLESPACE_NAME, 
				0 AS INITIAL_EXTENT,0 AS NEXT_EXTENT,'' AS COMMENTS,
				'{@TBLSYU}' TBLSYU,'{@SYSTEM_ID}' SYSTEM_ID
		from pg_tables
		<og:where>
			<og:and value = "TABLENAME like '{@TABLE_NAME}%'" />
			<og:and value = "SCHEMANAME = 'public'" />
		</og:where>
		order by TABLENAME
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,TABLE_NAME AS NAME_JA,
				COALESCE(NUM_ROWS,0) AS JKENSU,1000 AS SKENSU,TABLESPACE_NAME,
				INITIAL_EXTENT/1024 AS INITIAL_EXTENT,
				COALESCE(NEXT_EXTENT/1024,0) AS NEXT_EXTENT,'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_TABLES
		<og:where>
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value = "INSTR(TABLE_NAME,'$') < 1" />
		</og:where>
		order by TABLE_NAME
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select trim(RDB$RELATION_NAME) AS TABLE_NAME,trim(RDB$RELATION_NAME) AS NAME_JA,
				0 AS JKENSU,1000 AS SKENSU,'XX' AS TABLESPACE_NAME,
				0 AS INITIAL_EXTENT,
				0 AS NEXT_EXTENT,'' AS COMMENTS,
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from RDB$RELATIONS
		where RDB$SYSTEM_FLAG   = 0 
		and   RDB$RELATION_TYPE = 0 
		<og:where startKey="and">
			<og:and value = "RDB$RELATION_NAME like '{@TABLE_NAME}%'" />
		</og:where>
		order by RDB$RELATION_NAME
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2010}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},TABLE_NAME,NAME_JA" />
