/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19150C ( PACKAGE )                                                    */
/* Created : 2013/09/30 18:04:10                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE GFP19150C AS
/*******************************************************************************
*	Declare Package
*******************************************************************************/
PROCEDURE GF19150C(
	 PO_KEKKA		OUT	NUMBER													-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT	ERR_MSG_ARRAY											-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PI_NAMES		IN	VARCHAR2												-- 項目名
	,PI_SYSARGS		IN	SYSARG_ARRAY											-- ｼｽﾃﾑﾃﾞｰﾀ
	,PI_GF9150ARG	IN	GF9150ARG_ARRAY											-- 登録ﾃﾞｰﾀ配列
);
END;
/
/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19150C ( PACKAGE BODY )                                               */
/* Created : 2013/09/30 18:04:10                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE BODY GFP19150C AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19150C
*	処理名			:	登録前確認(警告)ﾁｪｯｸ
*	作成日			:	2012/08/10
*	作成者			:	A.SANPEI
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19150C(
	 PO_KEKKA		OUT	NUMBER													-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT	ERR_MSG_ARRAY											-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PI_NAMES		IN	VARCHAR2												-- 項目名
	,PI_SYSARGS		IN	SYSARG_ARRAY											-- ｼｽﾃﾑﾃﾞｰﾀ
	,PI_GF9150ARG	IN	GF9150ARG_ARRAY											-- 登録ﾃﾞｰﾀ配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	--定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)	:= 'GFP19150C';					-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)	:= PI_SYSARGS(1).PGID;			-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)	:= PI_SYSARGS(1).CDATE;			-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(10)	:= PI_SYSARGS(1).USERID;		-- ﾛｸﾞｲﾝﾕｰｻﾞｰ
--
	--変数定義
	G_I				NUMBER;														-- 行番号
	G_RTN			BOOLEAN;													-- ﾘﾀｰﾝ値
	G_ERRSTP		VARCHAR2(1000)	:= NULL;									-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;									-- ｷｰ項目
--
	--EXCEPTION定義
	UNMATCH_CDKH	EXCEPTION;
--
	--ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERROR_CHECK	RETURN BOOLEAN;
/*******************************************************************************
*	ERROR_CHECK 入力ｴﾗｰﾁｪｯｸ
*******************************************************************************/
FUNCTION ERROR_CHECK
RETURN BOOLEAN
IS
	L_COUNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='ERR_CHARCK';
--
	IF PI_SYSARGS(G_I).CDKH = 'A' THEN
		G_ERRSTP:='ERR_CHARCK_EXIST_A';
		--存在ﾁｪｯｸ
		SELECT	COUNT(*)
		INTO	L_COUNT
		FROM	GF41
		WHERE	SYSTEM_ID	=	PI_GF9150ARG(G_I).SYSTEM_ID						-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
		AND		LANG		=	PI_GF9150ARG(G_I).LANG							-- 言語   ＝ 画面》言語
		AND		CLM			=	PI_GF9150ARG(G_I).CLM							-- 項目   ＝ 画面》項目
		AND		FGJ			IN	('0','1');										-- 状態F  IN ('0','1')
--
		IF NVL(L_COUNT,0) > 0 THEN
			--「既にﾃﾞｰﾀが存在します。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,1													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0002'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
		END IF;
	ELSE
		G_ERRSTP:='ERR_CHARCK_EXIST_UD';
		--存在ﾁｪｯｸ
		SELECT	COUNT(*)
		INTO	L_COUNT
		FROM	GF41
		WHERE	SYSTEM_ID	=	PI_GF9150ARG(G_I).SYSTEM_ID						-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
		AND		LANG		=	PI_GF9150ARG(G_I).LANG							-- 言語   ＝ 画面》言語
		AND		CLM			=	PI_GF9150ARG(G_I).CLM							-- 項目   ＝ 画面》項目
		AND		FGJ			IN	('0','1');										-- 状態F  IN ('0','1')
--
		IF NVL(L_COUNT,0) <= 0 THEN
			--「ﾃﾞｰﾀが存在しません。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,1													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0003'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
		END IF;
--
		IF PI_GF9150ARG(G_I).NAME_JA = 'TEST' THEN
			--「ﾃﾞｰﾀが存在しません。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,1													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0003'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
		END IF;
--
		IF PI_GF9150ARG(G_I).NAME_JA = PI_GF9150ARG(G_I).LABEL_NAME THEN
			--「名称と表示名称に、同一の名称をセットしています。」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,1													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0008'											-- ｴﾗｰﾒｯｾｰｼﾞID
							);
		END IF;
--
	END IF;
--
	RETURN TRUE;
END ERROR_CHECK;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	--処理結果(1:警告)
	PO_KEKKA := 1;
--
	G_ERRSTP:='MAIN_ERR_LOOP';
	-- 登録ﾃﾞｰﾀﾁｪｯｸ処理ﾙｰﾌﾟ
	FOR I IN 1..PI_SYSARGS.COUNT LOOP
		G_I	:=	I;
		G_DISP_KEY := ' SYSTEM_ID='|| PI_GF9150ARG(G_I).SYSTEM_ID||
					  ' LANG='|| PI_GF9150ARG(G_I).LANG||
					  ' CLM='|| PI_GF9150ARG(G_I).CLM||
					  ' UNIQ='|| PI_GF9150ARG(G_I).UNIQ;
		--ｴﾗｰﾁｪｯｸ
		G_RTN := ERROR_CHECK;
	END LOOP;
--
	G_ERRSTP:='MAIN_E';
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);
--
/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- 「改廃ｺｰﾄﾞｴﾗｰ 改廃ｺｰﾄﾞ:{0}」
	WHEN UNMATCH_CDKH THEN
		HYBS.SET_ERRMSGS(PO_ERRMSGS												-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,'GFE0004'												-- ｴﾗｰﾒｯｾｰｼﾞID
						,PI_SYSARGS(G_I).CDKH									-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
						);
		PO_KEKKA := 2;
--
	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,'GFE0005'												-- 共通SPｴﾗｰ発生
						,G_DISP_KEY												-- ｷｰ項目
						);
		PO_KEKKA := 2;
--
	--	ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		PO_KEKKA := 2;
--
END GF19150C;
END GFP19150C;
/
