/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GANTT_PKG ( PACKAGE )                                                    */
/* Created : 2013/09/30 18:04:09                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE GANTT_PKG AS
/*****************************************************************************/
/*   title      ：  ラベル定義マスタ登録                                     */
/*   version    ：  001                                                      */
/*   date/author：  2003/06/30  K.Hasegawa(MIS)                              */
/*   text       ：  変更履歴管理開始                                         */
/*****************************************************************************/
    TYPE CUST_CURSOR IS REF CURSOR;
    PROCEDURE GANTTQUERY
    (
        P_KEKKA     OUT NUMBER
    ,   P_ERRMSGS   OUT ERR_MSG_ARRAY
    ,   P_RC1       OUT CUST_CURSOR
    ,   P_ARGS      IN  ARG_ARRAY
    );

    PROCEDURE GANTTOPERATE
    (
        P_KEKKA     OUT NUMBER
    ,   P_ERRMSGS   OUT ERR_MSG_ARRAY
    ,   P_RC1       OUT CUST_CURSOR
    ,   P_ARGS      IN  ARG_ARRAY
    );

END;
/
/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GANTT_PKG ( PACKAGE BODY )                                               */
/* Created : 2013/09/30 18:04:09                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE BODY GANTT_PKG AS

	cnFreeTaskId	CONSTANT PLS_INTEGER := -2;
	cnRestTaskId	CONSTANT PLS_INTEGER := -1;
    cnNoSuchTask    GF64.TASK_ID    %TYPE  := -98765;

	FUNCTION CheckDate
	(
		strText   VARCHAR2
	,	strFormat VARCHAR2 DEFAULT 'YYYYMMDD'
	)
	RETURN BOOLEAN
	IS
		dCheck DATE;
	BEGIN
		dCheck := TO_DATE(strText, strFormat);
		RETURN TRUE;
	EXCEPTION
		WHEN OTHERS THEN
			RETURN FALSE;
	END CheckDate;

    PROCEDURE GANTTQUERY
    (
        P_KEKKA     OUT NUMBER
    ,   P_ERRMSGS   OUT ERR_MSG_ARRAY
    ,   P_RC1       OUT CUST_CURSOR
    ,   P_ARGS      IN  ARG_ARRAY
    ) IS
		-------------------------------------------------------------------------------
		---------------------------<< 変数宣言 >> -------------------------------------
		-------------------------------------------------------------------------------

	    p_PRJCODE     GF62.PRJCODE    %TYPE  := P_ARGS(1);   --プロジェクトコード
	    p_RESID       GF63.RESOURCE_ID%TYPE  := P_ARGS(2);   --リソースID
	    p_DYFrom      GF64.DYSTART    %TYPE  := P_ARGS(3);   --日付From
	    p_DYTo        GF64.DYSTART    %TYPE  := P_ARGS(4);   --日付To
	    p_USRSET      GF62.USRSET     %TYPE  := P_ARGS(5);   --登録者

	    strDYSET    GF62.DYSET%TYPE     := TO_CHAR(SYSDATE, 'YYYYMMDDHH24MISS');
	    strDYUPD    GF62.DYUPD%TYPE     := strDYSET;
	    strPGUPD    GF62.PGUPD%TYPE     := 'GANTTQUERY';

		dDYFrom		DATE;
		dDYTo		DATE;

		nCountUp	PLS_INTEGER			:= 0;

		expCheck EXCEPTION;

    BEGIN
        P_KEKKA := 0;

		IF p_PRJCODE IS NULL THEN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	'ERR0012'		-- 指定のデータがセットされていません。（NULLエラー）。key={0}
			,	'{#PRJCODE}'	-- メッセージパラメータ１
			);
			RAISE expCheck;

		END IF;

		IF p_DYFrom IS NULL THEN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	'ERR0012'		-- 指定のデータがセットされていません。（NULLエラー）。key={0}
			,	'{#DYFROM}'	    -- メッセージパラメータ１
			);
			RAISE expCheck;
		ELSIF NOT CheckDate(p_DYFrom) THEN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	'ERR0030'		-- 入力したデータが不正です。key={0} value={1} 形式={2}
			,	'{#DYFROM}'	    -- メッセージパラメータ１
			,	p_DYFrom	    -- メッセージパラメータ２
			,	'YYYYMMDD'	    -- メッセージパラメータ３
			);
			RAISE expCheck;
		END IF;

		IF p_DYTo IS NULL THEN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	'ERR0012'		-- 指定のデータがセットされていません。（NULLエラー）。key={0}
			,	'{#DYTO}'	    -- メッセージパラメータ１
			);
			RAISE expCheck;
		ELSIF NOT CheckDate(p_DYTo) THEN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	'ERR0030'		-- 入力したデータが不正です。key={0} value={1} 形式={2}
			,	'{#DYTO}'	    -- メッセージパラメータ１
			,	'p_DYTo'	    -- メッセージパラメータ１
			,	'YYYYMMDD'   	    -- メッセージパラメータ2
			);
			RAISE expCheck;
		END IF;

		EXECUTE IMMEDIATE 'TRUNCATE TABLE GF68';

		dDYFrom		:= TO_DATE(p_DYFrom, 'YYYYMMDD');
        dDYTo		:= TO_DATE(p_DYTo  , 'YYYYMMDD');

		FOR recGF66 IN
		(	SELECT B.RESOURCE_ID, B.SEQ, LEAST(dDYFrom, TO_DATE(MIN(C.DYSTART), 'YYYYMMDD')) MinResStart
			FROM   GF66 A, GF65 B, GF64 C
			WHERE  A.PRJCODE     =  B.PRJCODE
			AND    A.RESOURCE_ID =  B.RESOURCE_ID
			AND    A.PRJCODE     =  C.PRJCODE
			AND    A.TASK_ID     =  C.TASK_ID
			AND    A.PRJCODE     =  p_PRJCODE
			AND    A.RESOURCE_ID =  NVL(p_RESID, A.RESOURCE_ID)
			AND    C.DYSTART     <= p_DYTo
			GROUP BY B.RESOURCE_ID, B.SEQ
			ORDER BY B.SEQ
		)
		LOOP
			FOR recView IN
			(
				SELECT	MIN(P.MYYYYYMMDD) MYYYYYMMDD, MIN(P.ATWORK), P.AGROUP
					,	CASE	WHEN P.ATWORK = 0      THEN cnRestTaskId
								WHEN P.MYDURATION < 0  THEN cnFreeTaskId
								ELSE TASK_ID
						END TASK_ID
					,	MIN(P.DYSTART)
					,	MIN(P.DURATION)
					,	COUNT(*) SUBDURATION
				FROM
				(
					SELECT	M.MYYYYYMMDD, M.ATWORK
						,	SUM(DECODE( M.ATWORK, M.NEXTATWORK, 0, 1)) OVER(ORDER BY M.MYYYYYMMDD) AGROUP
						,	MAX(M.TASK_ID ) OVER (PARTITION BY M.TGROUP) TASK_ID
						,	MAX(M.DYSTART ) OVER (PARTITION BY M.TGROUP) DYSTART
						,	MAX(M.DURATION) OVER (PARTITION BY M.TGROUP) DURATION
						,	FIRST_VALUE(NVL(M.DURATION, -1)) OVER (PARTITION BY M.TGROUP ORDER BY M.MYYYYYMMDD )
							  - SUM(M.ATWORK) OVER (PARTITION BY M.TGROUP ORDER BY M.MYYYYYMMDD ) MYDURATION
					FROM
					(
						SELECT	E.MYYYYYMMDD, E.ATWORK
							,	LAG( E.ATWORK ) OVER ( ORDER BY E.MYYYYYMMDD ) NEXTATWORK
							,	F.TASK_ID
							,	SUM(DECODE(F.TASK_ID, NULL, 0, 1)) OVER(ORDER BY E.MYYYYYMMDD) TGROUP
							,	F.DYSTART
							,	F.DURATION
						FROM
						(
							SELECT B.MYYYYYMMDD, B.ATWORK
							FROM
							(
								SELECT	A.YYYYMM || TO_CHAR(B.RD, 'FM00') MYYYYYMMDD
									,	DECODE(	SUBSTRB(
													MAX(
														DECODE( A.CDJGS, NULL, '0', '1') ||
														DECODE( B.RD
																, 1 , DY1 , 2 , DY2 , 3 , DY3 , 4 , DY4 , 5 , DY5
																, 6 , DY6 , 7 , DY7 , 8 , DY8 , 9 , DY9 , 10, DY10
																, 11, DY11, 12, DY12, 13, DY13, 14, DY14, 15, DY15
																, 16, DY16, 17, DY17, 18, DY18, 19, DY19, 20, DY20
																, 21, DY21, 22, DY22, 23, DY23, 24, DY24, 25, DY25
																, 26, DY26, 27, DY27, 28, DY28, 29, DY29, 30, DY30
																, 31, DY31, NULL)
														), 2)
												, '0', 1, 0) ATWORK
								FROM GF13 A, (SELECT ROWNUM RD FROM ALL_OBJECTS B WHERE ROWNUM <= 31 ) B
								WHERE ( A.CDJGS = TO_CHAR(recGF66.RESOURCE_ID)  OR A.CDJGS IS NULL )
								AND   A.YYYYMM >= TO_CHAR(recGF66.MinResStart, 'YYYYMM')
								AND   A.YYYYMM <= TO_CHAR(dDYTo, 'YYYYMM')
								GROUP BY A.YYYYMM || TO_CHAR(B.RD, 'FM00')
							) B
							WHERE B.MYYYYYMMDD IN ( SELECT TO_CHAR(recGF66.MinResStart + ROWNUM - 1, 'YYYYMMDD')
							                        FROM ALL_OBJECTS
							                        WHERE ROWNUM <= (dDYTo - recGF66.MinResStart + 1))
						) E,
						(
							SELECT C.TASK_ID, C.DYSTART, C.DURATION
							FROM   GF66 A, GF64 C
							WHERE  C.MEETING     =  '0'
							AND    A.PRJCODE     =  C.PRJCODE
							AND    A.TASK_ID     =  C.TASK_ID
							AND    A.PRJCODE     =  p_PRJCODE
							AND    A.RESOURCE_ID =  recGF66.RESOURCE_ID
							AND    C.DYSTART     <= p_DYTo
						) F
						WHERE E.MYYYYYMMDD = F.DYSTART(+)
						ORDER BY E.MYYYYYMMDD
					) M
					ORDER BY M.MYYYYYMMDD
				) P
				WHERE P.MYYYYYMMDD >= p_DYFrom AND P.MYYYYYMMDD <= p_DYTo
				GROUP BY P.AGROUP, P.TASK_ID
						,	CASE WHEN P.ATWORK = 0      THEN cnRestTaskId
							     WHEN P.MYDURATION < 0  THEN cnFreeTaskId
							     ELSE TASK_ID
							END
				ORDER BY 1
			)
			LOOP
				nCountUp := nCountUp + 1;

				INSERT INTO GF68
				(
					RESOURCE_ID				,	SEQ
				,	DYSTART					,	DYDELAY
				,	DURATION
				,	PRJCODE
				,	TASK_ID
				,	COMPLETE
				,	FGTASK
				,	VAL1					,	VAL2
				,	VAL3					,	VAL4
				,	VAL5
				,	UNIQ					,	FGJ
				,	DYSET					,	USRSET
				,	PGUPD
				)
				VALUES
				(
					recGF66.RESOURCE_ID		,	nCountUp
				,	recView.MYYYYYMMDD		,	0
				,	recView.SUBDURATION
				,	p_PRJCODE
				,	recView.TASK_ID
				,   100
				,	DECODE(recView.TASK_ID, cnFreeTaskId, '0', cnRestTaskId, '1', '2' )
				,	NULL					,	NULL
				,	NULL					,	NULL
				,	NULL
				,	GF68S01.NEXTVAL			,	'0'
				,	strDYSET				,	p_USRSET
				,	strPGUPD
				);
			END LOOP;
		END LOOP;

		COMMIT;

        OPEN P_RC1 FOR
			SELECT	A.PRJCODE	, A.RESOURCE_ID	, A.TASK_ID
				,	A.DYSTART	, A.DYDELAY		, A.DURATION
				,	A.FGTASK	, A.COMPLETE
				,	B.NAME_JA
				,	CASE WHEN A.TASK_ID >= 0 THEN B.DYSTART  ELSE A.DYSTART  END REALDYSTART
				,	CASE WHEN A.TASK_ID >= 0 THEN B.DURATION ELSE A.DURATION END REALDURATION
				,	CASE WHEN A.TASK_ID = -1 THEN '#DC143C'
						 WHEN A.TASK_ID = -2 THEN '#FF00FF'
						 ELSE B.COLOR
					END COLOR
			FROM	GF68 A, GF64 B
			WHERE	A.PRJCODE = B.PRJCODE(+)
			AND		A.TASK_ID = B.TASK_ID(+)
			ORDER BY A.SEQ;

    EXCEPTION
		WHEN expCheck THEN
            P_KEKKA := 2;

        WHEN OTHERS THEN
			--オラクルエラー。
            HYBS.SET_ERRMSGS
            (    P_ERRMSGS                  -- エラーメッセージ配列
            ,    1                          -- 行番号
            ,    2                          -- エラー結果(0:正常 1:警告 2:異常)
            ,    TO_CHAR(SQLCODE)           -- オラクルエラーコード
            ,    SUBSTRB( SQLERRM,1,100 )   -- オラクルエラーメッセージ
            );
            P_KEKKA := 2;
    END GANTTQUERY;

    PROCEDURE GANTTOPERATE
    (
        P_KEKKA     OUT NUMBER
    ,   P_ERRMSGS   OUT ERR_MSG_ARRAY
    ,   P_RC1       OUT CUST_CURSOR
    ,   P_ARGS      IN  ARG_ARRAY
    ) IS
		p_Operator	    CHAR                   := P_ARGS(1 );   --操作
	    p_PRJCODEFrom   GF62.PRJCODE    %TYPE  := P_ARGS(2 );   --プロジェクトコードFrom
	    p_TASKIDFrom    GF64.TASK_ID    %TYPE  := P_ARGS(3 );   --タスクIDFrom
	    p_RESIDFrom     GF63.RESOURCE_ID%TYPE  := P_ARGS(4 );   --リソースIDrom
	    p_DYSTARTFrom   GF64.DYSTART    %TYPE  := P_ARGS(5 );   --開始日From
	    p_DYDELAYFrom   GF68.DYDELAY    %TYPE  := P_ARGS(6 );   --開始遅延From
	    p_DURATIONFrom  GF64.DURATION   %TYPE  := P_ARGS(7 );   --期間From
		p_NAMEFrom		GF64.NAME_JA    %TYPE  := P_ARGS(8 );	--名称From
	    p_PRJCODETo     GF62.PRJCODE    %TYPE  := P_ARGS(9 );   --プロジェクトコードTo
	    p_TASKIDTo      GF64.TASK_ID    %TYPE  := P_ARGS(10);   --タスクIDTo
	    p_RESIDTo       GF63.RESOURCE_ID%TYPE  := P_ARGS(11);   --リソースIDrom
	    p_DYSTARTTo     GF64.DYSTART    %TYPE  := P_ARGS(12);   --開始日To
	    p_DYDELAYTo     GF68.DYDELAY    %TYPE  := P_ARGS(13);   --開始遅延To
	    p_DURATIONTo    GF64.DURATION   %TYPE  := P_ARGS(14);   --期間To
		p_NAMETo 		GF64.NAME_JA    %TYPE  := P_ARGS(15);	--名称To
	    p_USRSET        GF62.USRSET     %TYPE  := P_ARGS(16);   --登録者

	    strDYSET    GF62.DYSET%TYPE     := TO_CHAR(SYSDATE, 'YYYYMMDDHH24MISS');
	    strDYUPD    GF62.DYUPD%TYPE     := strDYSET;
	    strPGUPD   GF62.PGUPD%TYPE    := 'GANTTOP';

		asOp ARG_ARRAY := ARG_ARRAY('I', 'M', 'D', 'E', 'S');

		nCount	PLS_INTEGER;
		expCheck EXCEPTION;

		PROCEDURE ErrHandler
		(
			P_ID     IN   VARCHAR2
		,	P_MSG1   IN   VARCHAR2  DEFAULT NULL
		,	P_MSG2   IN   VARCHAR2  DEFAULT NULL
		,	P_MSG3   IN   VARCHAR2  DEFAULT NULL
		,	P_MSG4   IN   VARCHAR2  DEFAULT NULL
		,	P_MSG5   IN   VARCHAR2  DEFAULT NULL
		)
		IS
		BEGIN
			HYBS.SET_ERRMSGS
			(	P_ERRMSGS		-- エラーメッセージ配列
			,	0				-- 行番号
			,	2				-- エラー結果(0:正常 1:警告 2:異常)
			,	P_ID  		    --
			,	P_MSG1	        -- メッセージパラメータ1
			,	P_MSG2	        -- メッセージパラメータ2
			,	P_MSG3	        -- メッセージパラメータ3
			,	P_MSG4	        -- メッセージパラメータ4
			,	P_MSG5	        -- メッセージパラメータ5
			);
			RAISE expCheck;
		END ErrHandler;

	BEGIN
        P_KEKKA := 0;

		SELECT COUNT(*) INTO nCount FROM GF62 WHERE PRJCODE = p_PRJCODEFrom;
		IF 0 >= nCount THEN
			-- 該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}]
			ErrHandler('ERR0031', 'GF62', 'PRJCODE',p_PRJCODEFrom);
		END IF;

		SELECT COUNT(*) INTO nCount FROM GF63 WHERE RESOURCE_ID = p_RESIDFrom;
		IF 0 >= nCount THEN
			-- 該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}]
			ErrHandler('ERR0031', 'GF63', 'RESOURCE_ID',p_RESIDFrom);
		END IF;

		CASE p_Operator
		WHEN asOp(1) THEN
			UPDATE GF64
			SET   NAME_JA     =     p_NAMEFrom
			,     DYSTART     =     p_DYSTARTFrom
			,     DURATION    =     p_DURATIONFrom
			,     DYUPD       =     strDYUPD
			,     USRUPD      =     p_USRSET
			,     PGUPD      =     strPGUPD
			WHERE PRJCODE     =     p_PRJCODEFrom
			AND   TASK_ID     =     p_TASKIDFrom;

			IF SQL%NOTFOUND THEN
				INSERT INTO GF64
				(
				     PRJCODE                  ,    TASK_ID
				,    SEQ                      ,    TASK_LEVEL
				,    NAME_JA                  ,    MEETING
				,    DYSTART                  ,    DURATION
				,    COMPLETE                 ,    PRIORITY
				,    NOTES
				,    COLOR                    ,    SHAPE
				,    DEPEND_ID1               ,    DEPEND_TYPE1
				,    DEPEND_ID2               ,    DEPEND_TYPE2
				,    DEPEND_ID3               ,    DEPEND_TYPE3
				,    DEPEND_ID4               ,    DEPEND_TYPE4
				,    DEPEND_ID5               ,    DEPEND_TYPE5
				,    UNIQ
				,    FGJ
				,    DYSET                    ,    USRSET
				,    PGUPD
				)
				VALUES
				(
					 p_PRJCODEFrom            ,    p_TASKIDFrom
				,	 1                        ,	   1
				,    p_NAMEFrom               ,    '0'
				,    p_DYSTARTFrom            ,    p_DURATIONFrom
				,    0                        ,    9
				,    NULL
				,    '#00FF00'                ,    NULL
				,    NULL                     ,    NULL
				,    NULL                     ,    NULL
				,    NULL                     ,    NULL
				,    NULL                     ,    NULL
				,    NULL                     ,    NULL
				,    GF64S01.NEXTVAL
				,    '0'
				,    strDYSET                 ,    p_USRSET
				,    strPGUPD
				);
			END IF;

			UPDATE GF66
			SET   DYUPD       =     strDYUPD
			,     USRUPD      =     p_USRSET
			,     PGUPD      =     strPGUPD
			WHERE PRJCODE     =     p_PRJCODEFrom
			AND   TASK_ID     =     p_TASKIDFrom
			AND   RESOURCE_ID =     p_RESIDFrom;

			IF SQL%NOTFOUND THEN
				INSERT INTO GF66
				(
				     PRJCODE                  ,    TASK_ID
				,    RESOURCE_ID              ,    SEQ
				,    SU_LOAD                  ,    UNIQ
				,    FGJ
				,    DYSET                    ,    USRSET
				,    PGUPD
				)
				VALUES
				(
				     p_PRJCODEFrom            ,    p_TASKIDFrom
				,    p_RESIDFrom              ,    1
				,    100                      ,    GF66S01.NEXTVAL
				,    '0'
				,    strDYSET                 ,    p_USRSET
				,    strPGUPD
				);
			END IF;

		WHEN asOp(2) THEN
			UPDATE GF64
			SET   NAME_JA     =     p_NAMEFrom
			,     DYSTART     =     p_DYSTARTFrom
			,     DURATION    =     p_DURATIONFrom
			,     DYUPD       =     strDYUPD
			,     USRUPD      =     p_USRSET
			,     PGUPD      =     strPGUPD
			WHERE PRJCODE     =     p_PRJCODEFrom
			AND   TASK_ID     =     p_TASKIDFrom;

			IF SQL%NOTFOUND THEN
				-- ERR0032=該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}],[{3}:{4}]
				ErrHandler('ERR0032', 'GF64', 'PRJCODE',p_PRJCODEFrom, 'TASK_ID',p_TASKIDFrom);
			END IF;

		WHEN asOp(3) THEN
			DELETE FROM GF66
			WHERE PRJCODE     =     p_PRJCODEFrom
			AND   TASK_ID     =     p_TASKIDFrom
			AND   RESOURCE_ID =     p_RESIDFrom;

			IF SQL%NOTFOUND THEN
				-- ERR0025=データ未登録エラー。キー={0}、値={1} のデータは、存在していません。
				ErrHandler('ERR0025', 'GF66', 'PRJCODE,TASK_ID,RESOURCE_ID',p_PRJCODEFrom ||','||p_TASKIDFrom||','||p_RESIDFrom);
			END IF;

		WHEN asOp(4) THEN
			SELECT COUNT(*) INTO nCount FROM GF62 WHERE PRJCODE = p_PRJCODETo;
			IF 0 >= nCount THEN
			-- 該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}]
				ErrHandler('ERR0031', 'GF62', 'PRJCODE',p_PRJCODETo);
			END IF;

			SELECT COUNT(*) INTO nCount FROM GF63 WHERE RESOURCE_ID = p_RESIDTo;
			IF 0 >= nCount THEN
			-- 該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}]
				ErrHandler('ERR0031', 'GF63', 'RESOURCE_ID',p_RESIDTo);
			END IF;

			IF p_TASKIDFrom NOT IN ( cnFreeTaskId, cnRestTaskId ) THEN
				SELECT COUNT(*) INTO nCount FROM GF64 WHERE PRJCODE = p_PRJCODEFrom AND TASK_ID = p_TASKIDFrom;
				IF 0 >= nCount THEN
					-- ERR0032=該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}],[{3}:{4}]
					ErrHandler('ERR0032', 'GF64', 'PRJCODE',p_PRJCODEFrom, 'TASK_ID',p_TASKIDFrom);
				END IF;
			END IF;

			IF p_TASKIDTo NOT IN ( cnFreeTaskId, cnRestTaskId ) THEN
				SELECT COUNT(*) INTO nCount FROM GF64 WHERE PRJCODE = p_PRJCODETo AND TASK_ID = p_TASKIDTo;
				IF 0 >= nCount THEN
					-- ERR0032=該当データが存在しませんでした。Table={0} [key:val]=[{1}:{2}],[{3}:{4}]
					ErrHandler('ERR0032', 'GF64', 'PRJCODE',p_PRJCODETo, 'TASK_ID',p_TASKIDTo);
				END IF;
			END IF;

			CASE
			WHEN      p_TASKIDFrom NOT IN ( cnFreeTaskId, cnRestTaskId )
				 AND  p_TASKIDTo   NOT IN ( cnFreeTaskId, cnRestTaskId ) THEN
				UPDATE GF66
				SET   TASK_ID     =     cnNoSuchTask
				WHERE PRJCODE     =     p_PRJCODEFrom
				AND   TASK_ID     =     p_TASKIDFrom
				AND   RESOURCE_ID =     p_RESIDFrom;

				UPDATE GF66
				SET   TASK_ID     =     p_TASKIDFrom
				--,     RESOURCE_ID =     p_RESIDFrom
				,     DYUPD       =     strDYUPD
				,     USRUPD      =     p_USRSET
				,     PGUPD      =     strPGUPD
				WHERE PRJCODE     =     p_PRJCODETo
				AND   TASK_ID     =     p_TASKIDTo
				AND   RESOURCE_ID =     p_RESIDTo;

				UPDATE GF66
				SET   TASK_ID     =     p_TASKIDTo
				--,     RESOURCE_ID =     p_RESIDTo
				,     DYUPD       =     strDYUPD
				,     USRUPD      =     p_USRSET
				,     PGUPD      =     strPGUPD
				WHERE PRJCODE     =     p_PRJCODEFrom
				AND   TASK_ID     =     cnNoSuchTask
				AND   RESOURCE_ID =     p_RESIDFrom;
			WHEN      p_TASKIDFrom NOT IN ( cnFreeTaskId, cnRestTaskId )
				 AND  p_TASKIDTo       IN ( cnFreeTaskId, cnRestTaskId ) THEN
				UPDATE GF66
				SET   RESOURCE_ID =     p_RESIDTo
				WHERE PRJCODE     =     p_PRJCODEFrom
				AND   TASK_ID     =     p_TASKIDFrom
				AND   RESOURCE_ID =     p_RESIDFrom;
			WHEN     p_TASKIDFrom     IN ( cnFreeTaskId, cnRestTaskId )
				 AND  p_TASKIDTo   NOT IN ( cnFreeTaskId, cnRestTaskId ) THEN
				UPDATE GF66
				SET   RESOURCE_ID =     p_RESIDFrom
				,     DYUPD       =     strDYUPD
				,     USRUPD      =     p_USRSET
				,     PGUPD      =     strPGUPD
				WHERE PRJCODE     =     p_PRJCODETo
				AND   TASK_ID     =     p_TASKIDTo
				AND   RESOURCE_ID =     p_RESIDTo;
			ELSE
				NULL;
			END CASE;

			--UPDATE GF64
			--SET   TASK_ID     =     cnNoSuchTask
			--WHERE PRJCODE     =     p_PRJCODEFrom
			--AND   TASK_ID     =     p_TASKIDFrom;

			--UPDATE GF64
			--SET   TASK_ID     =     p_TASKIDFrom
			--,     NAME_JA     =     p_NAMEFrom
			--,     DYSTART     =     p_DYSTARTFrom
			--,     DURATION    =     p_DURATIONFrom
			--,     DYUPD       =     strDYUPD
			--,     USRUPD      =     p_USRSET
			--,     PGUPD      =     strPGUPD
			--WHERE PRJCODE     =     p_PRJCODETo
			--AND   TASK_ID     =     p_TASKIDTo;

			--UPDATE GF64
			--SET   TASK_ID     =     p_TASKIDTo
			--,     NAME_JA     =     p_NAMETo
			--,     DYSTART     =     p_DYSTARTTo
			--,     DURATION    =     p_DURATIONTo
			--,     DYUPD       =     strDYUPD
			--,     USRUPD      =     p_USRSET
			--,     PGUPD      =     strPGUPD
			--WHERE PRJCODE     =     p_PRJCODEFrom
			--AND   TASK_ID     =     cnNoSuchTask;

			UPDATE GF64
			SET   DYSTART     =     p_DYSTARTFrom
			,     DYUPD       =     strDYUPD
			,     USRUPD      =     p_USRSET
			,     PGUPD      =     strPGUPD
			WHERE PRJCODE     =     p_PRJCODETo
			AND   TASK_ID     =     p_TASKIDTo;

			UPDATE GF64
			SET   DYSTART     =     p_DYSTARTTo
			,     DYUPD       =     strDYUPD
			,     USRUPD      =     p_USRSET
			,     PGUPD      =     strPGUPD
			WHERE PRJCODE     =     p_PRJCODEFrom
			AND   TASK_ID     =     p_TASKIDFrom;

		WHEN asOp(5) THEN
			NULL;
		ELSE
			NULL;
		END CASE;

		COMMIT;

		OPEN P_RC1 FOR SELECT NULL FROM DUAL;

    EXCEPTION
		WHEN expCheck THEN
            ROLLBACK;
            P_KEKKA := 2;

        WHEN OTHERS THEN
			--オラクルエラー。
            HYBS.SET_ERRMSGS
            (    P_ERRMSGS                  -- エラーメッセージ配列
            ,    1                          -- 行番号
            ,    2                          -- エラー結果(0:正常 1:警告 2:異常)
            ,    TO_CHAR(SQLCODE)           -- オラクルエラーコード
            ,    SUBSTRB( SQLERRM,1,100 )   -- オラクルエラーメッセージ
            );
            ROLLBACK;
            P_KEKKA := 2;
    END GANTTOPERATE;

END GANTT_PKG;
/
