/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* VIEW_ZOOM ( FUNCTION )                                                   */
/* Created : 2013/09/30 18:24:49                                            */
/****************************************************************************/
CREATE OR REPLACE 
FUNCTION VIEW_ZOOM(
	XVAL    IN NUMBER   ,
	XZOOM   IN VARCHAR2 ,
	XBASE   IN NUMBER := 12  )
RETURN NUMBER
/**********************************************************************/
/* タスクの警告判定を行います。                                       */
/*  VIEW_ZOOM( VAL,ZOOM,BASE )                                        */
/*                                                                    */
/*	 VAL       IN NUMBER  (少数可)   計算される元の値                 */
/*	 ZOOM      IN VARCHAR2           表示ズームパラメータ             */
/*	 BASE      IN NUMBER             １ヶ月表示時の基準値 = 12        */
/*                                                                    */
/*	 リターン値   計算後の値 （整数）                                 */
/*                                                                    */
/*	表示ズームパラメータ に対応した倍率を計算した大きさを返します。   */
/*	相対計算する為、１ヶ月表示する場合の大きさをベースとして          */
/*	指定することで、画面に応じた大きさに変更できます。                */
/*	ベースは、デフォルトで 12 です。                                  */
/*                                                                    */
/*    ZOOM  ラベル        日数ピクセル変換率                          */
/*  =================================================                 */
/*      0 : １週間 日数 * 12 * 4   48    48px =  1日                  */
/*      1 : ２週間 日数 * 12 * 2   24    24px =  1日                  */
/*      2 : １ヶ月 日数 * 12       12    12px =  1日                  */
/*      3 : ２ヶ月 日数 * 12 / 1.5  8    56px =  7日 Ver3.6.0.0 訂正  */
/*      4 : ３ヶ月 日数 * 12 / 3    4    56px = 14日                  */
/*      5 : ４ヶ月 日数 * 12 / 4    3    90px = 30日                  */
/*      6 : ６ヶ月 日数 * 12 / 6    2    60px = 30日                  */
/*      7 : １年   日数 * 12 / 12   1    90px = 90日                  */
/*      8 : ２年   日数 * 12 / 24   0.5  90px =180日                  */
/*      9 : ３年   日数 * 12 / 36   0.33 60px =180日                  */
/*     10 : 週単位 日数 * 12 / 3.5  3.43 24px =  7日                  */
/*     11 : 予約済み(他物件使用済み)                                  */
/*     12 : 予約済み(他物件使用済み)                                  */
/*     20 :  1時間   時間 * 12 * 4        48 48px = 1時間(100)        */
/*     21 :  1時間2  時間 * 12 * 2        24 24px = 1時間(100)        */
/*     22 :  2時間   時間 * 12 * 4  /  2  24 48px = 2時間(100) Ver 3.8.9.2 */
/*     23 :  2時間2  時間 * 12 * 2  /  2  12 24px = 2時間(100) Ver 3.8.9.2 */
/*     24 :  4時間   時間 * 12 * 4  /  4  12 48px = 4時間(100) Ver 3.8.9.2 */
/*     25 :  4時間2  時間 * 12 * 2  /  4   6 24px = 4時間(100) Ver 3.8.9.2 */
/*     26 :  6時間   時間 * 12 * 4  /  6   8 48px = 6時間(100) Ver 3.8.9.2 */
/*     27 :  6時間2  時間 * 12 * 2  /  6   4 24px = 6時間(100) Ver 3.8.9.2 */
/*     28 :  8時間   時間 * 12 * 4  /  8   6 48px = 8時間(100) Ver 3.8.9.2 */
/*     29 :  8時間2  時間 * 12 * 2  /  8   3 24px = 8時間(100) Ver 3.8.9.2 */
/*     30 : 12時間   時間 * 12 * 4  / 12   4 48px =12時間(100) Ver 3.8.9.2 */
/*     31 : 12時間2  時間 * 12 * 2  / 12   2 24px =12時間(100) Ver 3.8.9.2 */
/*                                                                    */
/**********************************************************************/
IS
    RTN     NUMBER(6);

BEGIN

	IF    XZOOM = '0'  THEN RTN := TRUNC( XVAL * XBASE * 4.0  );
	ELSIF XZOOM = '1'  THEN RTN := TRUNC( XVAL * XBASE * 2.0  );
	ELSIF XZOOM = '2'  THEN RTN := TRUNC( XVAL * XBASE        );
	ELSIF XZOOM = '3'  THEN RTN := TRUNC( XVAL * XBASE / 1.5  );
	ELSIF XZOOM = '4'  THEN RTN := TRUNC( XVAL * XBASE / 3.0  );
	ELSIF XZOOM = '5'  THEN RTN := TRUNC( XVAL * XBASE / 4.0  );
	ELSIF XZOOM = '6'  THEN RTN := TRUNC( XVAL * XBASE / 6.0  );
	ELSIF XZOOM = '7'  THEN RTN := TRUNC( XVAL * XBASE / 12.0 );
	ELSIF XZOOM = '8'  THEN RTN := TRUNC( XVAL * XBASE / 24.0 );
	ELSIF XZOOM = '9'  THEN RTN := TRUNC( XVAL * XBASE / 36.0 );
	ELSIF XZOOM = '10' THEN RTN := TRUNC( XVAL * XBASE / 3.5  );
	ELSIF XZOOM = '20' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  100.0 );
	ELSIF XZOOM = '21' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  100.0 );
	ELSIF XZOOM = '22' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  200.0 );
	ELSIF XZOOM = '23' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  200.0 );
	ELSIF XZOOM = '24' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  400.0 );
	ELSIF XZOOM = '25' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  400.0 );
	ELSIF XZOOM = '26' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  600.0 );
	ELSIF XZOOM = '27' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  600.0 );
	ELSIF XZOOM = '28' THEN RTN := TRUNC( XVAL * XBASE * 4.0 /  800.0 );
	ELSIF XZOOM = '29' THEN RTN := TRUNC( XVAL * XBASE * 2.0 /  800.0 );
	ELSIF XZOOM = '30' THEN RTN := TRUNC( XVAL * XBASE * 4.0 / 1200.0 );
	ELSIF XZOOM = '31' THEN RTN := TRUNC( XVAL * XBASE * 2.0 / 1200.0 );
	END IF ;

	RETURN RTN;

END VIEW_ZOOM;
/
