/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* TEST11P ( PACKAGE )                                                      */
/* Created : 2013/09/30 18:04:01                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE TEST11P AS
/************************************************************************/
/* EXCEL取込 後処理 PL/SQL サンプル                                     */
/*                                                                      */
/*  TEST11P.TEST11( KEKKA,ERR_CODE,YKNO )                               */
/* { call 帳票IDP.帳票ID( 結果(STATUS),内容(ERR_MSG),PGID,要求番号 ) }  */
/* という PL/SQL を Call します。                                       */
/* 第１引数、第２引数は、OUT属性で、結果(STATUS)とエラー時の            */
/* 内容(ERR_MSG)を返してください。  第３引数は、起動元PGIDです。        */
/* 結果(STATUS)は、正常ならば、0 を返してください。                     */
/*                                                                      */
/* COMMIT/ROLLBACK は、呼び出しもとのプログラムで行います。             */
/* 正常時の GE50への完成フラグの書き込み、異常時のGE50、GE56への        */
/* 書き込みも呼び出しもとのプログラムで行います。                       */
/*                                                                      */
/************************************************************************/
	PROCEDURE TEST11 (
		PO_STATUS    OUT NUMBER ,
		PO_ERR_CODE  OUT VARCHAR2 ,
		PI_PRGID     IN  VARCHAR2 ,
		PI_YKNO      IN  NUMBER
	);
END;
/
/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* TEST11P ( PACKAGE BODY )                                                 */
/* Created : 2013/09/30 18:04:01                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE BODY TEST11P AS
	PROCEDURE TEST11 (
		PO_STATUS    OUT NUMBER ,
		PO_ERR_CODE  OUT VARCHAR2 ,
		PI_PRGID     IN  VARCHAR2 ,
		PI_YKNO      IN  NUMBER
	)
IS
	-- このサンプルでは、WKGE52_XIN と WKGE54_XIN テーブルについて
	-- 処理を行います。
	-- 具体的には、RELEASE_NOTES に、EXCELIN という文字列をセットします。
	-- わざわざ、１件ずつ処理するのは、サンプルだからです。:)

	CURSOR WKGE52 IS
		SELECT GESYSTEM_ID,GEYKNO,GESHEETNO,GEEDNO,RELEASE_NOTES,ROWID
			FROM WKGE52_XIN
			WHERE GEYKNO = PI_YKNO
			ORDER BY GESHEETNO,GEEDNO ;

	WKGE52REC WKGE52%ROWTYPE;

	CURSOR WKGE54 IS
		SELECT GESYSTEM_ID,GEYKNO,GESHEETNO,GEEDNO,RELEASE_NOTES,ROWID
			FROM WKGE54_XIN
			WHERE GEYKNO = PI_YKNO
			ORDER BY GESHEETNO,GEEDNO ;

	WKGE54REC WKGE54%ROWTYPE;

BEGIN
	PO_STATUS := 2;	-- 初期設定(エラー)

	OPEN	WKGE52;
	LOOP
		FETCH WKGE52 INTO WKGE52REC;
		EXIT WHEN WKGE52%NOTFOUND;

		UPDATE WKGE52_XIN SET RELEASE_NOTES = 'EXCELIN' WHERE ROWID = WKGE52REC.ROWID ;
	END LOOP;
	CLOSE WKGE52;

	OPEN	WKGE54;
	LOOP
		FETCH WKGE54 INTO WKGE54REC;
		EXIT WHEN WKGE54%NOTFOUND;

		UPDATE WKGE54_XIN SET RELEASE_NOTES = 'EXCELIN' WHERE ROWID = WKGE54REC.ROWID ;
	END LOOP;
	CLOSE WKGE54;

--	COMMIT;		呼び出し元で行います。
	PO_STATUS := 0;	-- 正常終了

EXCEPTION
	WHEN OTHERS THEN
--		ROLLBACK;		呼び出し元で行います。
		PO_STATUS := 2;
		PO_ERR_CODE	:= 'PGID=' || PI_PRGID || ' YKNO=' || PI_YKNO || ' ERR=' || TO_CHAR(SQLCODE) ;

END TEST11;
END TEST11P;
/
