/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19500S1 ( PACKAGE )                                                   */
/* Created : 2013/09/30 18:03:59                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE GFP19500S1 AS
/*******************************************************************************
*	Declare Package
*******************************************************************************/
TYPE CUST_CURSOR IS REF CURSOR;													-- 結果ｶｰｿﾙﾀｲﾌﾟ
PROCEDURE GF19500S1(
	 PO_KEKKA		OUT		NUMBER												-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT		ERR_MSG_ARRAY										-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PO_RC1			OUT		CUST_CURSOR											-- 結果ｶｰｿﾙ
	,PI_ARGS		IN		ARG_ARRAY											-- 条件配列
);
END;
/
/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19500S1 ( PACKAGE BODY )                                              */
/* Created : 2013/09/30 18:03:59                                            */
/****************************************************************************/
CREATE OR REPLACE 
PACKAGE BODY GFP19500S1 AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19500S1
*	処理名			:	一覧検索
*	作成日			:	2007/09/01
*	作成者			:	XXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19500S1 (
	 PO_KEKKA		OUT		NUMBER												-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT		ERR_MSG_ARRAY										-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PO_RC1			OUT		CUST_CURSOR											-- 結果ｶｰｿﾙ
	,PI_ARGS		IN		ARG_ARRAY											-- 条件配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	--定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)	:= 'GFP19500S1';				-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)	:= 'GF9500';					-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)	:= TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS');	-- ｼｽﾃﾑ日付

	--変数定義
	G_ERRSTP		VARCHAR2(1000)	:= NULL;
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;
	G_RTN			BOOLEAN;

	-- 条件配列
	G_SYSTEM_ID		GF41.SYSTEM_ID%TYPE		:= PI_ARGS(1);						--ｼｽﾃﾑID
	G_LANG			GF41.LANG%TYPE			:= PI_ARGS(2);						--言語
	G_CLM			GF41.CLM%TYPE			:= PI_ARGS(3);						--項目
	G_NAME_JA		GF41.NAME_JA%TYPE		:= PI_ARGS(4);						--名称（漢字）
	G_LABEL_NAME	GF41.LABEL_NAME%TYPE	:= PI_ARGS(5);						--表示名称
	G_KBSAKU		GF41.KBSAKU%TYPE		:= PI_ARGS(6);						--作成区分

	-- ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERR_CHECK_RTN	RETURN BOOLEAN;
/*******************************************************************************
*	ERR_CHECK_RTN ｴﾗｰﾁｪｯｸ
*******************************************************************************/
FUNCTION ERR_CHECK_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP:='ERR_CHECK_RTN';
	RETURN TRUE;
END ERR_CHECK_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	-- 処理結果(2:異常)
	PO_KEKKA := 2;

	-- ｴﾗｰﾁｪｯｸ処理
	G_RTN := ERR_CHECK_RTN;

	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

	IF	PO_KEKKA >= '2' THEN
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;
	ELSE
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT	 SYSTEM_ID													-- ｼｽﾃﾑID
					,LANG														-- 言語
					,CLM														-- 項目
					,NAME_JA													-- 名称(漢字)
					,LABEL_NAME													-- 表示名称
					,KBSAKU														-- 作成区分
					,CDTAN														-- 担当者
					,DECODE(KBSAKU,'0','0','1') AS ONMARK						-- (非表示)画像制御
			FROM	GF41
			WHERE	SYSTEM_ID	=		G_SYSTEM_ID								-- ｼｽﾃﾑID     ＝   画面》ｼｽﾃﾑID
			AND		LANG		LIKE	G_LANG			|| '%'					-- 言語       LIKE 画面》言語
			AND		CLM			=		NVL(G_CLM,CLM)							-- 項目       ＝   画面》項目
			AND		NAME_JA		LIKE	G_NAME_JA		|| '%'					-- 名称(漢字) LIKE 画面》名称(漢字)
			AND		LABEL_NAME	LIKE	G_LABEL_NAME	|| '%'					-- 表示名称   LIKE 画面》表示名称
			AND		KBSAKU		LIKE	G_KBSAKU		|| '%'					-- 作成区分   LIKE 画面》作成区分
			AND		FGJ			IN		('0','1')								-- 状態F      IN   ('0','1')
			ORDER BY SYSTEM_ID,CLM,LANG ;
	END IF;
/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	WHEN OTHERS THEN
		-- ｵﾗｸﾙｴﾗｰ
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		-- 処理結果(2:異常)
		PO_KEKKA := 2;
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;

END GF19500S1;

END GFP19500S1;
/
