<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0003"
	title    = "カラム"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="EXIST_GEA08" action="SET" value="0" />
</og:entry>

<og:equals val1="{@sqlType}" val2="DELETE" notEquals="true" >
	<og:tableExist
		dbid	= "{@MEM.TO_DBID}"
		command = "{@command}"
		from	= "GEA03"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND KBSAKU=[KBSAKU] AND FGJ in ('0','1')"
		errRemove = "{@errRemove}"
	/>
</og:equals>

<og:tableFilter classId="DBSELECT" dbid="{@MEM.TO_DBID}">
	select '1' EXIST_GEA08, A.UNIQ UNIQ_GEA08
	from GEA08 A
	where A.SYSTEM_ID = [SYSTEM_ID]
	and A.CLM = [CLM]
	and A.LANG = [LANG]
	and A.FGJ in ('0','1')
	order by A.SYSTEM_ID DESC, A.KBSAKU DESC
</og:tableFilter>
<og:equals val1="COPY|MODIFY|INSERT" val2="{@sqlType}" contains="true">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "0"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "INSERT"
			table		= "GEA08"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,SYSTEM_ID,LANG,RELEASE_NOTES,FGLOAD,CDKH,RDC_CODE"
			constKeys	= "KBLBL"
			constVals	= "1"
		/>
	</og:tableUpdate>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		conditionKey	= "EXIST_GEA08"
		conditionList	= "1"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "UPDATE"
			table		= "GEA08"
			where		= "UNIQ = [UNIQ_GEA08]"
			names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,SYSTEM_ID,LANG,RELEASE_NOTES,FGLOAD,CDKH,RDC_CODE"
			constKeys	= "KBLBL"
			constVals	= "1"
		/>
	</og:tableUpdate>
</og:equals>
<og:equals val1="DELETE" val2="{@sqlType}">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA08"
			where			= "UNIQ = [UNIQ_GEA08]"
			names			= "CDKH"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:equals>

<og:value command = "SETTBL" key = "CLM" action = "APPEND"/>
<og:tableUpdate
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	queryType		= "JDBCTableUpdate"
	resourceType	= "GEA03">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA03"
		where			= "UNIQ = [UNIQ]"
		names			= "CLM,NAME_JA,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,ROLES,DATA_DEFAULT,LABEL_CLM,CODE_CLM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,COMMENTS,KBSAKU,SYSTEM_ID,RELEASE_NOTES,FGLOAD,CDKH,RDC_CODE"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="COLUMN"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:value command="REMOVE" key="CLM" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
